<?php
/**
 * Jetpack Compatibility File
 * See: http://jetpack.me/
 *
 * @package WEN Business
 */

if ( ! function_exists( 'wen_business_jetpack_setup' ) ) :
  /**
   * Add theme support for Infinite Scroll.
   * See: http://jetpack.me/support/infinite-scroll/
   */
  function wen_business_jetpack_setup() {
    $pagination_type = wen_business_get_option( 'pagination_type' );
    if ( in_array( $pagination_type, array( 'infinite-scroll-click', 'infinite-scroll' ) ) ) {
      $type = ( 'infinite-scroll-click' == $pagination_type ) ? 'click' : 'scroll' ;
      add_theme_support( 'infinite-scroll', array(
        'type'      => $type,
        'container' => 'main',
        'footer'    => 'page',
        'render'    => 'wen_business_infinite_scroll_render',
      ) );
    } // end if
    // Add theme support for Responsive Videos.
    add_theme_support( 'jetpack-responsive-videos' );
  }
endif;

add_action( 'after_setup_theme', 'wen_business_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
function wen_business_infinite_scroll_render() {
  while ( have_posts() ) {
    the_post();
    if ( is_search() ) :
			get_template_part( 'template-parts/content', 'search' );
    else :
			get_template_part( 'template-parts/content', get_post_format() );
    endif;
  }
} // end function wen_business_infinite_scroll_render
