<?php

/**
 * Theme Shortcodes class.
 *
 * @since WEN Business 1.0
 *
 */
class WEN_Business_Theme_Shortcodes{

  protected $theme_data;

  /**
   * Construcor.
   *
   * @since WEN Business 1.0
   *
   */
  function __construct() {

    $this->setup();
    $this->init();

  }

  /**
   * Initial setup.
   *
   * @since WEN Business 1.0
   *
   */
  function setup(){

    $support = get_theme_support( 'theme-shortcodes' );
    if ( empty( $support ) ){
      return;
    }

    $this->theme_data = wp_get_theme();

  }

  /**
   * Initialize hooks.
   *
   * @since WEN Business 1.0
   *
   */
  function init() {

    // Register shortcodes
    add_shortcode( 'site_link' , array( $this, 'site_link' ) );
    add_shortcode( 'the_year' , array( $this, 'the_year' ) );
    add_shortcode( 'powered_by' , array( $this, 'powered_by' ) );
    add_shortcode( 'theme_credit' , array( $this, 'theme_credit' ) );

  }

  /**
   * [site_link] shortcode callback.
   *
   * @since WEN Business 1.0
   *
   */
  function site_link() {

    $output = sprintf(
      '<a href="%s" title="%s">%s</a>',
      esc_url( home_url( '/' ) ),
      esc_attr( get_bloginfo( 'name' ) ),
      esc_html( get_bloginfo( 'name' ) )
    );
    return $output;

  }

  /**
   * [the_year] shortcode callback.
   *
   * @since WEN Business 1.0
   *
   */
  function the_year() {

    return date( 'Y' );

  }

  /**
   * [powered_by] shortcode callback.
   *
   * @since WEN Business 1.0
   *
   */
  function powered_by() {

    ob_start();
    ?>
    <a href="<?php echo esc_url( __( 'http://wordpress.org/', 'wen-business-pro' ) ); ?>"><?php printf( esc_html__( 'Proudly powered by %s', 'wen-business-pro' ), 'WordPress' ); ?></a>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    return $output;

  }

  /**
   * [theme_credit] shortcode callback.
   *
   * @since WEN Business 1.0
   *
   */
  function theme_credit() {

    return sprintf( esc_html__( '%1$s by %2$s', 'wen-business-pro' ), esc_html( $this->theme_data->get( 'Name') ), '<a href="' . esc_url( $this->theme_data->get( 'AuthorURI') ) . '" rel="designer" target="_blank">' . esc_html( $this->theme_data->get( 'Author') ) . '</a>' );

  }


}

// Initialize
new WEN_Business_Theme_Shortcodes();
