<?php
/**
 * Footer Widgets class.
 *
 * @since WEN Business 1.0
 *
 */
class WEN_Business_Woocommerce{

  // protected $max_widgets = 0;

  // protected $active_widgets = 0;

  // protected $theme_prefix = 'wen_business';

  /**
   * Construcor.
   *
   * @since WEN Business 1.0
   *
   */
  function __construct() {

    $this->setup();
    $this->init();

  }
  /**
   * Initial setup.
   *
   * @since WEN Business 1.0
   *
   */
  function setup(){

  }
  /**
   * Initialize hooks.
   *
   * @since WEN Business 1.0
   *
   */
  function init() {

    // Wrapper
    add_action( 'widgets_init', array( $this, 'register_woo_sidebars' ) );
    // Wrapper
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
    add_action('woocommerce_before_main_content', array( $this, 'woo_wrapper_start' ), 10);
    add_action('woocommerce_after_main_content', array( $this, 'woo_wrapper_end' ), 10);

    // Breadcrumb
    add_filter( 'woocommerce_breadcrumb_defaults', array( $this, 'wen_business_woocommerce_breadcrumbs_defaults' ) );
    add_action( 'wp', array( $this, 'hooking_woo' ) );

    // Sidebar filter
    add_filter( 'wen_business_filter_default_sidebar_id', array( $this, 'sidebar_defaults' ), 10, 2 );

    // Sidebar
    add_action( 'woocommerce_sidebar', array( $this, 'wen_business_add_secondary_sidebar' ), 11 );

    // Customizer options
    add_filter( 'wen_business_theme_options_args', array( $this, 'customizer_fields' ), 15 );

    // Modify global layout
    add_filter( 'wen_business_filter_theme_global_layout', array( $this, 'modify_global_layout' ), 15 );


  }

  /**
   * Hooking Woocommerce.
   *
   * @since  WEN Business 1.0
   */
  function hooking_woo(){
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    if ( 'disabled' != wen_business_get_option('breadcrumb_type') && is_woocommerce() ) {
      add_action( 'wen_business_action_before_content', 'woocommerce_breadcrumb', 7 );
      remove_action( 'wen_business_action_before_content', 'wen_business_add_breadcrumb', 7 );
    }

    // Fixing primary sidebar
    $global_layout = wen_business_get_option( 'global_layout' );
    $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );
    if ( in_array( $global_layout, array( 'no-sidebar', 'no-sidebar-centered' ) ) ) {
      remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
    }

  }

  /**
   * Filter Woo default sidebar.
   *
   * @since  WEN Business 1.0
   */
  function sidebar_defaults( $id, $location ){
    switch ( $location ) {
      case 'primary':
        $woo_sidebar_primary = wen_business_get_option( 'woo_sidebar_primary' );
        if ( ! empty( $woo_sidebar_primary ) ) {
          $id = esc_attr( $woo_sidebar_primary );
        }
        break;
      case 'secondary':
        $woo_sidebar_secondary = wen_business_get_option( 'woo_sidebar_secondary' );
        if ( ! empty( $woo_sidebar_secondary ) ) {
          $id = esc_attr( $woo_sidebar_secondary );
        }
        break;

      default:
        break;
    }
    return $id;

  }

  /**
   * Modify global layout.
   *
   * @since  WEN Business 1.0
   */
  function modify_global_layout( $layout ){

    $woo_page_layout = wen_business_get_option( 'woo_page_layout' );

    if ( is_woocommerce() && ! empty( $woo_page_layout ) ) {
      $layout = esc_attr( $woo_page_layout );
    }

    // Fix for shop page.
    if ( is_shop() && ( $shop_id = absint( wc_get_page_id( 'shop' ) ) ) > 0 ) {
    	$post_options = get_post_meta( $shop_id, 'theme_settings', true );
    	if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
    		$layout = esc_attr( $post_options['post_layout'] );
    	}
    }

    return $layout;

  }

  /**
   * Filter Woo default sidebar.
   *
   * @since  WEN Business 1.0
   */
  function customizer_fields( $args ){

    $args['panels']['theme_option_panel']['sections']['section_theme_woo'] = array(
      'title'       => __( 'WooCommerce Options', 'wen-business-pro' ),
      'description' => __( 'Settings specific to WooCommerce. Note: WooCommerce Page means shop page, product page and product archive page.', 'wen-business-pro' ),
      'priority'    => 90,
      'fields'   => array(
        'woo_page_layout' => array(
          'title'             => __( 'Content Layout', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_global_layout_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'woo_sidebar_primary' => array(
          'title'             => __( 'Primary Sidebar', 'wen-business-pro' ),
          'description'       => __( 'Choose Primary Sidebar for WooCommerce pages. If not selected default sidebar will be displayed.', 'wen-business-pro' ),
          'type'              => 'dropdown-sidebars',
          'sanitize_callback' => 'sanitize_key',
        ),
        'woo_sidebar_secondary' => array(
          'title'             => __( 'Sidebar Sidebar', 'wen-business-pro' ),
          'description'       => __( 'Choose Secondary Sidebar for WooCommerce pages. If not selected default sidebar will be displayed.', 'wen-business-pro' ),
          'type'              => 'dropdown-sidebars',
          'sanitize_callback' => 'sanitize_key',
        ),
      )
    );


    return $args;
  }

  /**
   * Register Woocommerce sidebars.
   *
   * @since  WEN Business 1.0
   */
  function register_woo_sidebars(){

    register_sidebar( array(
      'name'          => __( 'WooCommerce Primary', 'wen-business-pro' ),
      'id'            => 'sidebar-woocommerce-primary',
      'before_widget' => '<aside id="%1$s" class="widget %2$s">',
      'after_widget'  => '</aside>',
      'before_title'  => '<h3 class="widget-title">',
      'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
      'name'          => __( 'WooCommerce Secondary', 'wen-business-pro' ),
      'id'            => 'sidebar-woocommerce-secondary',
      'before_widget' => '<aside id="%1$s" class="widget %2$s">',
      'after_widget'  => '</aside>',
      'before_title'  => '<h3 class="widget-title">',
      'after_title'   => '</h3>',
    ) );

  }

  /**
   * Add secondary sidebar in Woocommerce.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_add_secondary_sidebar(){

    $global_layout = wen_business_get_option( 'global_layout' );
    $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );

    switch ( $global_layout ) {
      case 'three-columns':
      case 'three-columns-pcs':
      case 'three-columns-cps':
      case 'three-columns-psc':
      case 'three-columns-pcs-equal':
      case 'three-columns-scp-equal':
        get_sidebar( 'secondary' );
        break;

      default:
        break;
    }

  }

  /**
   * Woocommerce content wrapper start.
   *
   * @since  WEN Business 1.0
   */
  function woo_wrapper_start() {
    echo '<div id="primary" ';
    wen_business_content_class( 'content-area' );
    echo '>';
  }

  /**
   * Woocommerce content wrapper end.
   *
   * @since  WEN Business 1.0
   */
  function woo_wrapper_end() {
    echo '</div><!-- #primary -->';
  }

  /**
   * Woocommerce breadcrumb defaults
   *
   * @since  WEN Business 1.0
   */
  function wen_business_woocommerce_breadcrumbs_defaults() {

    $breadcrumb_separator = wen_business_get_option( 'breadcrumb_separator' );
    $breadcrumb_separator = ( empty( $breadcrumb_separator ) ) ? '&#47;' : esc_attr( $breadcrumb_separator ) ;

    return array(
      'delimiter'   => ' ' . $breadcrumb_separator . ' ',
      'wrap_before' => '<div id="breadcrumb" itemprop="breadcrumb"><div class="container">',
      'wrap_after'  => '</div></div>',
      'before'      => '',
      'after'       => '',
      'home'        => get_bloginfo( 'name' ),
    );
  }



} // end class


// Initialize
$wen_business_woocommerce = new WEN_Business_Woocommerce();
