<div class="authorbox <?php echo ( 1 != get_option( 'show_avatars' ) ) ? 'no-author-avatar' : ''; ?>">
  <?php if ( 1 == get_option('show_avatars') ): ?>
  <div class="author-avatar">
    <?php echo get_avatar( get_the_author_meta( 'user_email' ), '80', '' ); ?>
  </div>
  <?php endif ?>
  <div class="author-info">
    <h4 class="author-header">
      <?php _e( 'Written by', 'wen-business-pro' ); ?>&nbsp;<?php  the_author_posts_link(); ?>
    </h4>
    <?php $user_url = get_the_author_meta( 'user_url' ); ?>
    <?php if ( ! empty( $user_url ) ): ?>
      <div class="author-footer"><a href="<?php echo esc_url( $user_url ); ?>" target="_blank"><?php _e( 'Website', 'wen-business-pro' ); ?></a></div>
    <?php endif ?>
    <div class="author-content"><p><?php the_author_meta('description'); ?></p></div>
  </div>
  <?php
    $author_bio_show_recent_posts = wen_business_get_option( 'author_bio_show_recent_posts' );
    $author_bio_recent_posts_number = wen_business_get_option( 'author_bio_recent_posts_number' );
   ?>
   <?php if ( true == $author_bio_show_recent_posts && absint( $author_bio_recent_posts_number ) > 0 ): ?>

      <?php
        $custom_args = array(
          'author'         => get_the_author_meta( 'ID' ),
          'posts_per_page' => $author_bio_recent_posts_number,
          );
        $all_posts = get_posts( $custom_args );
       ?>

       <?php if ( ! empty( $all_posts ) ): ?>

        <ul class="author-bio-posts-list">
          <?php foreach ( $all_posts as $key => $p ): ?>
            <li><a href="<?php echo esc_url( get_permalink( $p->ID ) ); ?>" title="<?php echo esc_attr( $p->post_title ); ?>"><?php echo apply_filters( 'the_title', $p->post_title ); ?></a></li>
          <?php endforeach ?>
        </ul>

       <?php endif ?>


   <?php endif ?>
</div>
