<?php
/**
 * @package WEN Business
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php wen_business_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

  <?php
    $archive_layout          =  wen_business_get_option( 'archive_layout' );
    $archive_image           =  wen_business_get_option( 'archive_image' );
    $archive_image_alignment =  wen_business_get_option( 'archive_image_alignment' );
   ?>

   <div class="entry-content">

      <?php if ( 'disable' != $archive_image && has_post_thumbnail() ): ?>

        <?php $class =  esc_attr( 'align' . $archive_image_alignment ) ?>
        <?php the_post_thumbnail( esc_attr( $archive_image ), array( 'class' => $class ) ); ?>

      <?php endif; ?>

     <?php if ( 'excerpt' == $archive_layout ): ?>

        <?php the_excerpt(); ?>

       <?php else: ?>

        <?php
          /* translators: %s: Name of current post */
          the_content( sprintf(
            __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'wen-business-pro' ),
            the_title( '<span class="screen-reader-text">"', '"</span>', false )
          ) );
        ?>
        <?php
          wp_link_pages( array(
            'before' => '<div class="page-links">' . __( 'Pages:', 'wen-business-pro' ),
            'after'  => '</div>',
          ) );
        ?>


     <?php endif; ?>

   </div><!-- .entry-content -->


	<footer class="entry-footer">
		<?php wen_business_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
