<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package WEN Business
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'wen-business-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'wen-business-pro' ),
		'license-key'               => __( 'License Key', 'wen-business-pro' ),
		'license-action'            => __( 'License Action', 'wen-business-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'wen-business-pro' ),
		'activate-license'          => __( 'Activate License', 'wen-business-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'wen-business-pro' ),
		'renew'                     => __( 'Renew?', 'wen-business-pro' ),
		'unlimited'                 => __( 'unlimited', 'wen-business-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'wen-business-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'wen-business-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'wen-business-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'wen-business-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'wen-business-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'wen-business-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'wen-business-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'wen-business-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'wen-business-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'wen-business-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'wen-business-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'wen-business-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'wen-business-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'wen-business-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'wen-business-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'wen-business-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'wen-business-pro' ),
		'key-not-activated'         => __( '%1$s License Key has not been activated, so the theme is inactive. %2$sClick here%3$s to activate the license key and the theme.', 'wen-business-pro' ),
		'get-license-key'           => __( 'Get API key from %s.', 'wen-business-pro' ),
		'theme-palace'              => __( 'Theme Palace', 'wen-business-pro' ),
	)
);
