<?php

if ( ! class_exists( 'WP_Customize_Control' ) )
  return NULL;


/**
 * Customize Control for Heading
 */
class WEN_Customize_Heading_Control extends WP_Customize_Control {

  public $type = 'heading';

  public function render_content() {

    ?>
      <h3 class="wen-customize-heading"><?php echo esc_html( $this->label ); ?></h3><!-- .wen-customize-heading -->
    <?php
  }

}


/**
 * Customize Control for Message
 */
class WEN_Customize_Message_Control extends WP_Customize_Control {

  public $type = 'message';

  public function render_content() {

    ?>
      <div class="wen-customize-message">
        <?php echo wp_kses_post( $this->description ); ?>
      </div> <!-- .wen-customize-message -->
    <?php
  }

}

/**
 * Customize Control for Radio Image
 */
class WEN_Customize_Radio_Image_Control extends WP_Customize_Control {

  public $type = 'radio-image';

  public function render_content() {

    if ( empty( $this->choices ) )
      return;

    $name = '_customize-radio-' . $this->id;

    ?>
    <label>
      <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>

      <?php
      foreach ( $this->choices as $value => $label ) :
        ?>
        <label>
          <input type="radio" value="<?php echo esc_attr( $value ); ?>" <?php $this->link(); checked( $this->value(), $value ); ?> class="stylish-radio-image" name="<?php echo esc_attr( $name ); ?>"/>
            <span><img src="<?php echo esc_url($label); ?>" alt="<?php echo esc_attr( $value ); ?>" /></span>
        </label>
        <?php
      endforeach;
       ?>

    </label>
    <?php
  }

}


/**
 * Customize Control for Taxonomy Select
 */
class WEN_Customize_Dropdown_Taxonomies_Control extends WP_Customize_Control {

  public $type = 'dropdown-taxonomies';

  public $taxonomy = '';


  public function __construct( $manager, $id, $args = array() ) {

    $our_taxonomy = 'category';
    if ( isset( $args['taxonomy'] ) ) {
      $taxonomy_exist = taxonomy_exists( esc_attr( $args['taxonomy'] ) );
      if ( true === $taxonomy_exist ) {
        $our_taxonomy = esc_attr( $args['taxonomy'] );
      }
    }
    $args['taxonomy'] = $our_taxonomy;
    $this->taxonomy = esc_attr( $our_taxonomy );

    parent::__construct( $manager, $id, $args );
  }

  public function render_content() {

    $tax_args = array(
      'hierarchical' => 0,
      'taxonomy'     => $this->taxonomy,
    );
    $all_taxonomies = get_categories( $tax_args );

    ?>
    <label>
      <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
         <select <?php echo $this->link(); ?>>
            <?php
              printf('<option value="%s" %s>%s</option>', '', selected($this->value(), '', false),__( 'Select', 'wen-business-pro' ) );
             ?>
            <?php if ( ! empty( $all_taxonomies ) ): ?>
              <?php foreach ( $all_taxonomies as $key => $tax ): ?>
                <?php
                  printf('<option value="%s" %s>%s</option>', $tax->term_id, selected($this->value(), $tax->term_id, false), $tax->name );
                 ?>
              <?php endforeach ?>
           <?php endif ?>
         </select>

    </label>
    <?php
  }

}


/**
 * Customize Control for Menu Select
 */
class WEN_Customize_Dropdown_Menus_Control extends WP_Customize_Control {

  public $type = 'dropdown-menus';

  public function render_content() {

    $all_menus = wp_get_nav_menus();

    ?>
    <label>
      <?php if ( ! empty( $this->label ) ) : ?>
        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
      <?php endif;
      if ( ! empty( $this->description ) ) : ?>
        <span class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
      <?php endif; ?>

         <select <?php echo $this->link(); ?>>
            <?php
              printf('<option value="%s" %s>%s</option>', '', selected($this->value(), '', false),__( 'Select Menu', 'wen-business-pro' ) );
             ?>
            <?php if ( ! empty( $all_menus ) ): ?>
              <?php foreach ( $all_menus as $key => $menu ): ?>
                <?php
                  printf('<option value="%s" %s>%s</option>', $menu->term_id, selected($this->value(), $menu->term_id, false), $menu->name );
                 ?>
              <?php endforeach ?>
           <?php endif ?>
         </select>

    </label>
    <?php
  }

}

/**
 * Create a Dropdown Sidebars control
 */
class WEN_Customize_Dropdown_Sidebars_Control extends WP_Customize_Control {

  /**
   * Declare the control type.
   *
   * @access public
   * @var string
   */
  public $type = 'dropdown-sidebars';

  /**
   * Render the control to be displayed in the Customizer.
   */
  public function render_content() {

    global $wp_registered_sidebars;

    $all_sidebars = $wp_registered_sidebars;
    ?>

    <label>
      <?php if ( ! empty( $this->label ) ) : ?>
        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
      <?php endif;
      if ( ! empty( $this->description ) ) : ?>
        <span class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
      <?php endif; ?>
      <select <?php echo $this->link(); ?>>
         <?php
           printf( '<option value="%s" %s>%s</option>', '', selected( $this->value(), '', false ), ' ' );
          ?>
         <?php if ( ! empty( $all_sidebars ) ): ?>
           <?php foreach ( $all_sidebars as $key => $sidebar ): ?>
             <?php
               printf( '<option value="%s" %s>%s</option>', esc_attr( $key ), selected( $this->value(), $key, false ), esc_html( $sidebar['name'] ) );
              ?>
           <?php endforeach ?>
        <?php endif ?>
      </select>
    </label>

    <?php
  }

}
