<?php
/**
 * Wen Travel Pro functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WEN_Travel
 */

/**
 * Add an HTML class to MediaElement.js container elements to aid styling.
 *
 * Extends the core _wpmejsSettings object to add a new feature via the
 * MediaElement.js plugin API.
 */
function wen_travel_mejs_add_container_class() {
	if ( ! wp_script_is( 'mediaelement', 'done' ) ) {
		return;
	}
	?>
	<script>
	(function() {
		var settings = window._wpmejsSettings || {};

		settings.features = settings.features || mejs.MepDefaults.features;

		settings.features.push( 'wen_travel_class' );

		MediaElementPlayer.prototype.buildwen_travel_class = function(player, controls, layers, media) {
			if ( ! player.isVideo ) {
				var container = player.container[0] || player.container;

				container.style.height = '';
				container.style.width = '';
				player.options.setDimensions = false;
			}

			if ( jQuery( '#' + player.id ).parents('#sticky-playlist-section').length ) {
				player.container.addClass( 'wen-travel-mejs-container wen-travel-mejs-sticky-playlist-container' );

				jQuery( '#' + player.id ).parent().children('.wp-playlist-tracks').addClass('displaynone');

				var volume_slider = controls[0].children[5];

				if ( jQuery( '#' + player.id ).parent().children('.wp-playlist-tracks').length > 0) {
					var playlist_button =
					jQuery('<div class="mejs-button mejs-playlist-button mejs-toggle-playlist">' +
						'<button type="button" aria-controls="mep_0" title="Toggle Playlist"></button>' +
					'</div>')

					// append it to the toolbar
					.appendTo( jQuery( '#' + player.id ) )

					// add a click toggle event
					.on( 'click',function() {
						jQuery( '#' + player.id ).parent().children('.wp-playlist-tracks').slideToggle();
						jQuery( this ).toggleClass('is-open')
					});

					var play_button = controls[0].children[0];

					// Add next button after volume slider
					var next_button =
					jQuery('<div class="mejs-button mejs-next-button mejs-next">' +
						'<button type="button" aria-controls="' + player.id
						+ '" title="Next Track"></button>' +
					'</div>')

					// insert after volume slider
					.insertAfter(play_button)

					// add a click toggle event
					.on( 'click',function() {
						jQuery( '#' + player.id ).parent().find( '.wp-playlist-next').trigger('click');
					});

					// Add prev button after volume slider
					var previous_button =
					jQuery('<div class="mejs-button mejs-previous-button mejs-previous">' +
						'<button type="button" aria-controls="' + player.id
						+ '" title="Previous Track"></button>' +
					'</div>')

					// insert after volume slider
					.insertBefore( play_button )

					// add a click toggle event
					.on( 'click',function() {
						jQuery( '#' + player.id ).parent().find( '.wp-playlist-prev').trigger('click');
					});
				}
			} else {
				player.container.addClass( 'wen-travel-mejs-container' );
				if ( jQuery( '#' + player.id ).parent().children('.wp-playlist-tracks').length > 0) {
					var play_button = controls[0].children[0];

					// Add next button after volume slider
					var next_button =
					jQuery('<div class="mejs-button mejs-next-button mejs-next">' +
						'<button type="button" aria-controls="' + player.id
						+ '" title="Next Track"></button>' +
					'</div>')

					// insert after volume slider
					.insertAfter(play_button)

					// add a click toggle event
					.on( 'click',function() {
						jQuery( '#' + player.id ).parent().find( '.wp-playlist-next').trigger('click');
					});

					// Add prev button after volume slider
					var previous_button =
					jQuery('<div class="mejs-button mejs-previous-button mejs-previous">' +
						'<button type="button" aria-controls="' + player.id
						+ '" title="Previous Track"></button>' +
					'</div>')

					// insert after volume slider
					.insertBefore( play_button )

					// add a click toggle event
					.on( 'click',function() {
						jQuery( '#' + player.id ).parent().find( '.wp-playlist-prev').trigger('click');
					});
				}
			}
		}
	})();
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'wen_travel_mejs_add_container_class' );

if ( ! function_exists( 'wen_travel_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function wen_travel_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Wen Travel Pro, use a find and replace
		 * to change 'wen-travel-pro' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'wen-travel-pro', get_parent_theme_file_path( '/languages' ) );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * This theme styles the visual editor to resemble the theme style,
		 * specifically font, colors, and column width.
		 *
		 * Google fonts url addition
		 *
		 * Font Awesome addition
		 */
		add_editor_style( array(
			'css/editor-style.css',
			wen_travel_fonts_url(),
			)
		);

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// Used in Portfolio
		set_post_thumbnail_size( 508, 508, true ); // Ratio 1:1

		// Used in Archive: Excerpt image
		add_image_size( 'wen-travel-archive', 508, 381, true ); // Ratio 4:3

		// Used in featured slider
		add_image_size( 'wen-travel-slider', 1920, 1080, true );

		// Used in featured content
		add_image_size( 'wen-travel-featured-content', 666, 444, true ); // Ration 3:2

		// Used in logo slider
		add_image_size( 'wen-travel-logo-slider', 140, 80, true ); // Ratio 4:3

		// Used in Team Section
		add_image_size( 'wen-travel-team', 260, 260, true ); // Ratio 1:1

		// Used in Stats Section
		add_image_size( 'wen-travel-stats', 80, 80, true ); // Ratio 1:1

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1'        => esc_html__( 'Primary', 'wen-travel-pro' ),
			'social-top'    => esc_html__( 'Top Social', 'wen-travel-pro' ),
			'social-menu'   => esc_html__( 'Header Social', 'wen-travel-pro' ),
			'social-footer' => esc_html__( 'Footer Social', 'wen-travel-pro' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		/**
		 * Add support for essential widget image.
		 *
		 */
		add_theme_support( 'ew-newsletter-image' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => esc_html__( 'Small', 'wen-travel-pro' ),
					'shortName' => esc_html__( 'S', 'wen-travel-pro' ),
					'size'      => 12,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__( 'Normal', 'wen-travel-pro' ),
					'shortName' => esc_html__( 'M', 'wen-travel-pro' ),
					'size'      => 16,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__( 'Large', 'wen-travel-pro' ),
					'shortName' => esc_html__( 'L', 'wen-travel-pro' ),
					'size'      => 49,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__( 'Huge', 'wen-travel-pro' ),
					'shortName' => esc_html__( 'XL', 'wen-travel-pro' ),
					'size'      => 58,
					'slug'      => 'huge',
				),
			)
		);

		// Add support for custom color scheme.
		add_theme_support( 'editor-color-palette', array(
			array(
				'name'  => esc_html__( 'White', 'wen-travel-pro' ),
				'slug'  => 'white',
				'color' => '#ffffff',
			),
			array(
				'name'  => esc_html__( 'Black', 'wen-travel-pro' ),
				'slug'  => 'black',
				'color' => '#333',
			),
			array(
				'name'  => esc_html__( 'Gray', 'wen-travel-pro' ),
				'slug'  => 'gray',
				'color' => '#444444',
			),
			array(
				'name'  => esc_html__( 'Medium Gray', 'wen-travel-pro' ),
				'slug'  => 'medium-gray',
				'color' => '#7b7b7b',
			),
			array(
				'name'  => esc_html__( 'Light Gray', 'wen-travel-pro' ),
				'slug'  => 'light-gray',
				'color' => '#f6f6f6',
			),
			array(
				'name'  => esc_html__( 'Light Red', 'wen-travel-pro' ),
				'slug'  => 'light-red',
				'color' => '#fa6742',
			),
		) );
	}
endif;
add_action( 'after_setup_theme', 'wen_travel_setup' );

/**
 * Count the number of footer sidebars to enable dynamic classes for the footer
 *
 */
function wen_travel_footer_sidebar_class() {
	$count = 0;

	if ( is_active_sidebar( 'sidebar-2' ) ) {
		$count++;
	}

	if ( is_active_sidebar( 'sidebar-3' ) ) {
		$count++;
	}

	if ( is_active_sidebar( 'sidebar-4' ) ) {
		$count++;
	}

	if ( is_active_sidebar( 'sidebar-5' ) ) {
		$count++;
	}

	$class = '';

	switch ( $count ) {
		case '1':
			$class = 'one';
			break;
		case '2':
			$class = 'two';
			break;
		case '3':
			$class = 'three';
			break;
		case '4':
			$class = 'four';
			break;
	}

	if ( $class ) {
		echo 'class="widget-area footer-widget-area ' . esc_attr( $class ) . '"';
	}
}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function wen_travel_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'wen_travel_content_width', 920 );
}
add_action( 'after_setup_theme', 'wen_travel_content_width', 0 );

if ( ! function_exists( 'wen_travel_template_redirect' ) ) :
	/**
	 * Set the content width in pixels, based on the theme's design and stylesheet for different value other than the default one
	 *
	 * @global int $content_width
	 */
	function wen_travel_template_redirect() {
		$layout = wen_travel_get_theme_layout();

		if ( 'no-sidebar-full-width' === $layout ) {
			$GLOBALS['content_width'] = 1510;
		}
	}
endif;
add_action( 'template_redirect', 'wen_travel_template_redirect' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function wen_travel_widgets_init() {
	$args = array(
		'before_widget' => '<section id="%1$s" class="widget %2$s"> <div class="widget-wrap">',
		'after_widget'  => '</div></section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	);

	register_sidebar( array(
		'name'        => esc_html__( 'Sidebar', 'wen-travel-pro' ),
		'id'          => 'sidebar-1',
		'description' => esc_html__( 'Add widgets here.', 'wen-travel-pro' ),
		) + $args
	);

	register_sidebar( array(
		'name'        => esc_html__( 'Footer 1', 'wen-travel-pro' ),
		'id'          => 'sidebar-2',
		'description' => esc_html__( 'Add widgets here to appear in your footer.', 'wen-travel-pro' ),
		) + $args
	);

	register_sidebar( array(
		'name'        => esc_html__( 'Footer 2', 'wen-travel-pro' ),
		'id'          => 'sidebar-3',
		'description' => esc_html__( 'Add widgets here to appear in your footer.', 'wen-travel-pro' ),
		) + $args
	);

	register_sidebar( array(
		'name'        => esc_html__( 'Footer 3', 'wen-travel-pro' ),
		'id'          => 'sidebar-4',
		'description' => esc_html__( 'Add widgets here to appear in your footer.', 'wen-travel-pro' ),
		) + $args
	);

	register_sidebar( array(
		'name'        => esc_html__( 'Footer 4', 'wen-travel-pro' ),
		'id'          => 'sidebar-5',
		'description' => esc_html__( 'Add widgets here to appear in your footer.', 'wen-travel-pro' ),
		) + $args
	);

	if ( class_exists( 'WooCommerce' ) ) {
		//Optional Primary Sidebar for Shop
		register_sidebar( array(
			'name'        => esc_html__( 'WooCommerce Sidebar', 'wen-travel-pro' ),
			'id'          => 'sidebar-woo',
			'description' => esc_html__( 'This is Optional Sidebar for WooCommerce Pages', 'wen-travel-pro' ),
			) + $args
		);
	}

	// Registering 404 Error Page Content
	register_sidebar( array(
		'name'          => esc_html__( '404 Page Not Found Content', 'wen-travel-pro' ),
		'id'            => 'sidebar-notfound',
		'description'   => esc_html__( 'Replaces the default 404 Page Not Found Content', 'wen-travel-pro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s"> <div class="widget-wrap">',
		'after_widget'  => '</div></section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	//Optional Sidebar for Hompeage instead of main sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Homepage Sidebar', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-homepage',
		'description'   => esc_html__( 'This is Optional Sidebar for Homepage', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar for Archive instead of main sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Archive Sidebar', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-archive',
		'description'   => esc_html__( 'This is Optional Sidebar for Archive', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar for Page instead of main sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Page Sidebar', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-page',
		'description'   => esc_html__( 'This is Optional Sidebar for Page', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar for Post instead of main sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Post Sidebar', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-post',
		'description'   => esc_html__( 'This is Optional Sidebar for Post', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar one for page and post
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Sidebar One', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-one',
		'description'   => esc_html__( 'This is Optional Sidebar One', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar two for page and post
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Sidebar Two', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-two',
		'description'   => esc_html__( 'This is Optional Sidebar Two', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar Three for page and post
	register_sidebar( array(
		'name'          => esc_html__( 'Optional Sidebar Three', 'wen-travel-pro' ),
		'id'            => 'sidebar-optional-three',
		'description'   => esc_html__( 'This is Optional Sidebar Three', 'wen-travel-pro' ),
		) + $args
	);

	//Optional Sidebar Six Footer Newsletter
	register_sidebar( array(
		'name'          => esc_html__( 'Newsletter', 'wen-travel-pro' ),
		'id'            => 'sidebar-newsletter',
		'description'   => esc_html__( 'This is for Newsletter Template Widget Area.', 'wen-travel-pro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">
		<div class="widget-wrap"><div class="widget-inner">',
		'after_widget'  => '</div></div></section>',
		'before_title'  => '<div class="section-title-wrapper"><h2 class="section-title">',
		'after_title'   => '</h2></div>'
	) );
}
add_action( 'widgets_init', 'wen_travel_widgets_init' );

if ( ! function_exists( 'wen_travel_fonts_url' ) ) :
	/**
	 * Register Google fonts for Wen Travel Pro
	 *
	 * Create your own wen_travel_fonts_url() function to override in a child theme.
	 *
	 * @since Wen Travel Pro 1.0
	 *
	 * @return string Google fonts URL for the theme.
	 */
	function wen_travel_fonts_url() {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		$font_values = array();
		$fonts_list  = wen_travel_font_family_options();

		foreach ( $fonts_list as $key => $font_list ) {
			$font_values[] = get_theme_mod( $key, $font_list['default'] );
		}

		$web_fonts = array(
			'allan'               => 'Allan',
			'allerta'             => 'Allerta',
			'alegreya'            => 'Alegreya Sans',
			'amaranth'            => 'Amaranth',
			'amatic-sc'           => 'Amatic SC',
			'bitter'              => 'Bitter',
			'cabin'               => 'Cabin',
			'cantarell'           => 'Cantarell',
			'crimson-text'        => 'Crimson+Text',
			'cuprum'              => 'Cuprum',
			'dancing-script'      => 'Dancing Script',
			'droid-sans'          => 'Droid Sans',
			'droid-serif'         => 'Droid Serif',
			'exo'                 => 'Exo',
			'exo-2'               => 'Exo 2',
			'istok-web'           => 'Istok Web',
			'josefin-sans'        => 'Josefin Sans',
			'lato'                => 'Lato',
			'lobster'             => 'Lobster',
			'lora'                => 'Lora',
			'mrs-saint-delafield' => 'Mrs Saint Delafield',
			'montserrat'          => 'Montserrat',
			'muli'                => 'Muli',
			'nobile'              => 'Nobile',
			'noto-serif'          => 'Noto Serif',
			'neuton'              => 'Neuton',
			'open-sans'           => 'Open Sans',
			'oswald'              => 'Oswald',
			'patua-one'           => 'Patua One',
			'poppins'             => 'Poppins',
			'playfair-display'    => 'Playfair Display',
			'pt-sans'             => 'PT Sans',
			'pt-serif'            => 'PT Serif',
			'rubik'               => 'Rubik',
			'quattrocento-sans'   => 'Quattrocento Sans',
			'roboto'              => 'Roboto',
			'roboto-slab'         => 'Roboto Slab',
			'source-sans-pro'     => 'Source Sans Pro',
			'ubuntu'              => 'Ubuntu',
			'varela'              => 'Varela',
			'yanone-kaffeesatz'   => 'Yanone Kaffeesatz',
		);

		$font_values = array_unique( $font_values ); // Make the array of fonts unique so that same font is not loaded twice.

		$font_values = array_intersect( $font_values, array_keys( $web_fonts ) ); // Intersect selected fonts and webfonts to only recover fonts that need loading.

		foreach ( $font_values as $font_value ) {
			$fonts[] = $web_fonts[ $font_value ] . ':300,400,500,600,700,800,400italic,700italic';
		}

		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}

		$font_load = get_theme_mod( 'load_font_cdn' );

		if ( ! $font_load ) {
			require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );
		
			$fonts_url = wptt_get_webfont_url( $fonts_url );
		}

		return esc_url( $fonts_url );
	}
endif;

/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 * @since Wen Travel Pro 1.0
 */
function wen_travel_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'wen_travel_javascript_detection', 0 );

/**
 * Enqueue scripts and styles.
 */
function wen_travel_scripts() {
	$min  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'wen-travel-fonts', wen_travel_fonts_url(), array(), null );

	// Theme stylesheet.
	wp_enqueue_style( 'wen-travel-style', get_stylesheet_uri(), null, date( 'Ymd-Gis', filemtime( get_template_directory() . '/style.css' ) ) );

	// Theme block stylesheet.
	wp_enqueue_style( 'wen-travel-block-style', get_theme_file_uri( '/css/blocks.css' ), array( 'wen-travel-style' ), date( 'Ymd-Gis', filemtime( get_template_directory() . '/css/blocks.css' ) ) );

	// Load the html5 shiv.
	wp_enqueue_script( 'wen-travel-html5',  get_theme_file_uri() . 'js/html5' . $min . '.js', array(), '3.7.3' );

	wp_script_add_data( 'wen-travel-html5', 'conditional', 'lt IE 9' );

	wp_enqueue_script( 'wen-travel-skip-link-focus-fix', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/skip-link-focus-fix' . $min . '.js', array(), '201800703', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	$enable_featured_content = wen_travel_check_section( get_theme_mod( 'wen_travel_featured_content_option', 'disabled' ) );

	if( $enable_featured_content ) {
		wp_enqueue_script( 'jquery-match-height', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/jquery.matchHeight' . $min . '.js', array( 'jquery' ), '201800703', true );

		$deps[] = 'jquery-match-height';
	} 

	$deps[] = 'jquery';

	//Slider Scripts
	$enable_slider             = wen_travel_check_section( get_theme_mod( 'wen_travel_slider_option', 'disabled' ) );
	$enable_logo_slider        = wen_travel_check_section( get_theme_mod( 'wen_travel_logo_slider_option', 'disabled' ) );
	$enable_testimonial_slider = wen_travel_check_section( get_theme_mod( 'wen_travel_testimonial_option', 'disabled' ) );

	$slider_trans_in       = get_theme_mod( 'wen_travel_slider_transition_in', 'default' );
	$slider_trans_out      = get_theme_mod( 'wen_travel_slider_transition_out', 'default' );
	$testimonial_trans_in  = get_theme_mod( 'wen_travel_testimonial_transition_in', 'default' );
	$testimonial_trans_out = get_theme_mod( 'wen_travel_testimonial_transition_out', 'default' );
	$logo_slider_trans_in  = get_theme_mod( 'wen_travel_logo_slider_transition_in', 'default' );
	$logo_slider_trans_out = get_theme_mod( 'wen_travel_logo_slider_transition_out', 'default' );

	if ( $enable_slider || $enable_testimonial_slider || $enable_logo_slider ) {
		// Enqueue owl carousel css. Must load CSS before JS.
		wp_enqueue_style( 'owl-carousel-core', get_theme_file_uri( 'css/owl-carousel/owl.carousel.min.css' ), null, '2.3.4' );
		wp_enqueue_style( 'owl-carousel-default', get_theme_file_uri( 'css/owl-carousel/owl.theme.default.min.css' ), null, '2.3.4' );

		if ( ( $enable_slider && ( 'default' !== $slider_trans_in || 'default' !== $slider_trans_out ) )
		|| ( $enable_logo_slider && ( 'default' !== $logo_slider_trans_in || 'default' !== $logo_slider_trans_out ) )
		|| ( $enable_testimonial_slider && ( 'default' !== $testimonial_trans_in || 'default' !== $testimonial_trans_out ) ) ) {
			wp_enqueue_style( 'animate', get_theme_file_uri( 'css/animate.css' ), null, '3.7.0' );
		}

		// Enqueue script
		wp_enqueue_script( 'owl-carousel', get_theme_file_uri( 'js/owl.carousel' . $min . '.js'), array( 'jquery' ), '2.3.4', true );

		$deps[] = 'owl-carousel';

	}

	//Isotope
	$enable_collection  = wen_travel_check_section( get_theme_mod( 'wen_travel_collection_option', 'disabled' ) );
	$enable_portfolio   = wen_travel_check_section( get_theme_mod( 'wen_travel_portfolio_option', 'disabled' ) );
	$enable_attraction   = wen_travel_check_section( get_theme_mod( 'wen_travel_attraction_option', 'disabled' ) );

	if ( $enable_portfolio || $enable_collection || $enable_attraction ) {
		// Isotope JS.
		wp_register_script( 'jquery-isotope', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/isotope' . $min . '.js', array(), '2.0.1', true );

		$deps[] = 'jquery-isotope';
	}

	// Add masonry to dependent scripts of main script.
	$deps[] = 'jquery-masonry';

	$enable_video   = wen_travel_check_section( get_theme_mod( 'wen_travel_featured_video_option', 'disabled' ) );
	$video_lightbox = get_theme_mod( 'wen_travel_featured_video_show_lightbox', 'enabled' );

	$enable_hero        = wen_travel_check_section( get_theme_mod( 'wen_travel_hero_content_visibility', 'disabled' ) );
	$enable_promo       = wen_travel_check_section( get_theme_mod( 'wen_travel_promo_head_visibility', 'disabled' ) );
	$hero_content_video = get_theme_mod( 'wen_travel_hero_content_video_link' );
	$promo_head_video   = get_theme_mod( 'wen_travel_promo_head_video_link' );

	if ( ( $enable_video && 'enabled' === $video_lightbox ) || ( $enable_hero && $hero_content_video ) || ( $enable_promo && $promo_head_video ) ) {
		//Flashy for video section
		wp_enqueue_style( 'wen-travel-flashy', get_theme_file_uri( 'css/flashy.min.css' ) );

		wp_enqueue_script( 'wen-travel-jquery-flashy', get_theme_file_uri( 'js/jquery.flashy' . $min . '.js' ), array( 'jquery' ), '201800703', true );

		$deps[] = 'wen-travel-jquery-flashy';
	}

	// Countdown Scripts.
	$enable_countdown = wen_travel_check_section( get_theme_mod( 'wen_travel_countdown_option', 'disabled' ) );

	if ( $enable_countdown ) {
		wp_register_script( 'jquery-countdown', get_theme_file_uri( 'js/jquery.countdown' . $min . '.js' ), null, '2.2.0', true );

		$deps[] = 'jquery-countdown';

	}

	if ( $enable_video ) {
		wp_enqueue_script( 'jquery-simplebar', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/simplebar' . $min . '.js', array( 'jquery' ), '4.0.0-alpha.5', true );

		wp_enqueue_style( 'jquery-simplebar', get_theme_file_uri( 'css/simplebar.css' ), null );

		// Enqueue fitvid
		wp_enqueue_script( 'jquery-fitvids', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/fitvids' . $min . '.js', array( 'jquery' ), '1.1', true );
	}

	wp_enqueue_script( 'wen-travel-script', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/functions' . $min . '.js', $deps, date( 'Ymd-Gis', filemtime( get_template_directory() . '/' . 'js/functions' . $min . '.js' ) ), true );

	if ( $enable_countdown ) {
		// Add 10 Days to current Date.
		$default = current_time( 'Y-m-d H:i:s' );
		$default_date = date( 'Y-m-d H:i:s', strtotime( $default . '+ 10 days') );

		$end_date = get_theme_mod( 'wen_travel_countdown_end_date', $default_date );

		wp_localize_script( 'wen-travel-script', 'wenTravelCountdownEndDate', array( $end_date ) );
	}

	wp_localize_script( 'wen-travel-script', 'wenTravelOptions', array(
		'screenReaderText' => array(
			'expand'   => esc_html__( 'expand child menu', 'wen-travel-pro' ),
			'collapse' => esc_html__( 'collapse child menu', 'wen-travel-pro' ),
			'icon'     => wen_travel_get_svg( array(
					'icon'     => 'angle-down',
					'fallback' => true,
				)
			),
		),
		'sliderOptions' => array(
			'transitionIn'      => esc_js( $slider_trans_in ),
			'transitionOut'     => esc_js( $slider_trans_out ),
			'nav'               => esc_js( ! get_theme_mod( 'wen_travel_slider_nav', 0 ) ),
			'autoplay'          => esc_js( ! get_theme_mod( 'wen_travel_slider_autoplay', 1 ) ),
			'loop'              => esc_js( get_theme_mod( 'wen_travel_slider_loop' ) ),
			'transitionTimeout' => esc_js( get_theme_mod( 'wen_travel_slider_transition_timeout', 4 ) ),
			'dots'              => esc_js( ! get_theme_mod( 'wen_travel_slider_dots', 0 ) ),
		),
		'logoSliderOptions' => array(
			'transitionIn'      => esc_js( $logo_slider_trans_in ),
			'transitionOut'     => esc_js( $logo_slider_trans_out ),
			'nav'               => esc_js( ! get_theme_mod( 'wen_travel_logo_slider_nav' ) ),
			'autoplay'          => esc_js( ! get_theme_mod( 'wen_travel_logo_slider_autoplay' ) ),
			'loop'              => esc_js( get_theme_mod( 'wen_travel_logo_slider_loop' ) ),
			'transitionTimeout' => esc_js( get_theme_mod( 'wen_travel_logo_slider_transition_timeout', 4 ) ),
			'layout'            => esc_js( get_theme_mod( 'wen_travel_logo_slider_layout', 5 ) ),
			'dots'              => esc_js( ! get_theme_mod( 'wen_travel_logo_slider_dots', 0 ) ),
		),
		'testimonialOptions' => array(
			'transitionIn'      => esc_js( $testimonial_trans_in ),
			'transitionOut'     => esc_js( $testimonial_trans_out ),
			'nav'               => esc_js( ! get_theme_mod( 'wen_travel_testimonial_nav' ) ),
			'autoplay'          => esc_js( ! get_theme_mod( 'wen_travel_testimonial_autoplay', 1 ) ),
			'loop'              => esc_js( ! get_theme_mod( 'wen_travel_testimonial_loop', 1 ) ),
			'transitionTimeout' => esc_js( get_theme_mod( 'wen_travel_testimonial_transition_timeout', 4 ) ),
			'dots'              => esc_js( ! get_theme_mod( 'wen_travel_testimonial_dots', 1 ) ),
		),
		'iconNavPrev'     => wen_travel_get_svg( array(
				'icon'     => 'angle-left',
				'fallback' => true,
			)
		),
		'iconNavNext'     => wen_travel_get_svg( array(
				'icon'     => 'angle-right',
				'fallback' => true,
			)
		),
		'rtl' => is_rtl(),
	) );

	// Remove Media CSS, we have ouw own CSS for this.
	wp_deregister_style('wp-mediaelement');
}
add_action( 'wp_enqueue_scripts', 'wen_travel_scripts' );

/**
 * Enqueue editor styles for Gutenberg
 */
function wen_travel_block_editor_styles() {
	// Block styles.
	wp_enqueue_style( 'wen-travel-block-editor-style', get_theme_file_uri( 'css/editor-blocks.css' ) );

	// Add custom fonts.
	wp_enqueue_style( 'wen-travel-fonts', wen_travel_fonts_url(), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'wen_travel_block_editor_styles' );

if ( ! function_exists( 'wen_travel_excerpt_length' ) ) :
	/**
	 * Sets the post excerpt length to n words.
	 *
	 * function tied to the excerpt_length filter hook.
	 * @uses filter excerpt_length
	 *
	 * @since Wen Travel Pro 1.0
	 */
	function wen_travel_excerpt_length( $length ) {
		if ( is_admin() ) {
			return $length;
		}

		// Getting data from Customizer Options
		$length	= get_theme_mod( 'wen_travel_excerpt_length', 20 );

		return absint( $length );
	}
endif; //wen_travel_excerpt_length
add_filter( 'excerpt_length', 'wen_travel_excerpt_length', 999 );

if ( ! function_exists( 'wen_travel_excerpt_more' ) ) :
	/**
	 * Replaces "[...]" (appended to automatically generated excerpts) with ... and a option from customizer
	 *
	 * @return string option from customizer prepended with an ellipsis.
	 */
	function wen_travel_excerpt_more( $more ) {
		if ( is_admin() ) {
			return $more;
		}

		$more_tag_text = get_theme_mod( 'wen_travel_excerpt_more_text',  esc_html__( 'Continue reading', 'wen-travel-pro' ) );

		$link = sprintf( '<p><a href="%1$s" class="more-link">%2$s</a></p>',
			esc_url( get_permalink() ),
			/* translators: %s: Name of current post */
			wp_kses_data( $more_tag_text ). '<span class="screen-reader-text">' . get_the_title( get_the_ID() ) . '</span>'
		);

		if ( 'itineraries' === get_post_type() ) {
	        $link = '';
	    }

		return ' &hellip; ' . $link;
	}
endif;
add_filter( 'excerpt_more', 'wen_travel_excerpt_more' );

if ( ! function_exists( 'wen_travel_custom_excerpt' ) ) :
	/**
	 * Adds Continue reading link to more tag excerpts.
	 *
	 * function tied to the get_the_excerpt filter hook.
	 *
	 * @since Wen Travel Pro 1.0
	 */
	function wen_travel_custom_excerpt( $output ) {
		if ( has_excerpt() && ! is_attachment() ) {
			$more_tag_text = get_theme_mod( 'wen_travel_excerpt_more_text', esc_html__( 'Continue reading', 'wen-travel-pro' ) );

			$link = sprintf( '<a href="%1$s" class="more-link">%2$s</a>',
				esc_url( get_permalink() ),
				/* translators: %s: Name of current post */
				wp_kses_data( $more_tag_text ). '<span class="screen-reader-text">' . get_the_title( get_the_ID() ) . '</span>'
			);

			if ( 'itineraries' === get_post_type() ) {
		        $link = '';
		    }

			$output .= $link;
		}

		return $output;
	}
endif; //wen_travel_custom_excerpt
add_filter( 'get_the_excerpt', 'wen_travel_custom_excerpt' );

if ( ! function_exists( 'wen_travel_more_link' ) ) :
	/**
	 * Replacing Continue reading link to the_content more.
	 *
	 * function tied to the the_content_more_link filter hook.
	 *
	 * @since Wen Travel Pro 1.0
	 */
	function wen_travel_more_link( $more_link, $more_link_text ) {
		$more_tag_text = get_theme_mod( 'wen_travel_excerpt_more_text', esc_html__( 'Continue reading', 'wen-travel-pro' ) );

		return ' &hellip; ' . str_replace( $more_link_text, wp_kses_data( $more_tag_text ), $more_link );
	}
endif; //wen_travel_more_link
add_filter( 'the_content_more_link', 'wen_travel_more_link', 10, 2 );

/**
 * Checks if there are options already present from free version and adds it to the Pro theme options
 *
 * @since Wen Travel Pro 1.0
 * @hook after_theme_switch
 */
function wen_travel_setup_options( $old_theme_name ) {
	if ( $old_theme_name ) {
		$old_theme_slug = sanitize_title( $old_theme_name );
		$free_version_slug = array(
			'wen-travel',
			'wen-travel-blog',
			'wen-travel-dark',
			'wen-travel-modern',
			'wen-travel-photography',
			'wen-travel-corporate',
		);

		$pro_version_slug  = 'wen-travel-pro';

		$free_options = get_option( 'theme_mods_' . $old_theme_slug );


		// Perform action only if theme_mods_wen_travel free version exists.
		if ( in_array( $old_theme_slug, $free_version_slug ) && $free_options && '1' !== get_theme_mod( 'free_pro_migration' ) ) {
			$new_options = wp_parse_args( get_theme_mods(), $free_options );

			if ( 'wen-travel-blog' === $old_theme_slug ) {
				$free_options['color_scheme']                      		= 'blog';
				$free_options['theme_scheme']                      		= 'blog';
				$free_options['wen_travel_header_style']		   		= 'style-two';
				$free_options['wen_travel_featured_content_type']  		= 'page';
				$free_options['wen_travel_portfolio_two_type']     		= 'page';
				$free_options['wen_travel_service_type']           		= 'page';
				$free_options['wen_travel_testimonial_type']       		= 'page';
				$free_options['wen_travel_slider_type']            		= 'page';
				$free_options['wen_travel_transparent_header']     		=  0;
				$free_options['wen_travel_header_media_image_opacity']  = '50';

				$color_schemes  = wen_travel_get_color_schemes();
				$color_scheme   = $color_schemes['blog']['colors'];
				
				foreach ( $color_scheme as $key => $color ) {
					if ( 'background_color' === $key ) {
						$color = trim( $color, '#' );
					}
					
					$free_options[ $key ] = $color;
				}
			} 

			if ( 'wen-travel-dark' === $old_theme_slug ) {
				$free_options['color_scheme']                      		= 'dark';
				$free_options['theme_scheme']                      		= 'default';
				$free_options['wen_travel_featured_content_type']  		= 'page';
				$free_options['wen_travel_portfolio_type']     		    = 'page';
				$free_options['wen_travel_collection_type']     		= 'page';
				$free_options['wen_travel_service_type']           		= 'page';
				$free_options['wen_travel_testimonial_type']       		= 'page';
				$free_options['wen_travel_slider_type']            		= 'page';
				$free_options['wen_travel_logo_slider_type']            = 'page';
				$free_options['wen_travel_display_hero_content_title']  = 1;

				$color_schemes  = wen_travel_get_color_schemes();
				$color_scheme   = $color_schemes['dark']['colors'];
				
				foreach ( $color_scheme as $key => $color ) {
					if ( 'background_color' === $key ) {
						$color = trim( $color, '#' );
					}

					$free_options[ $key ] = $color;
				}
			}

			if ( 'wen-travel-modern' === $old_theme_slug ) {
				$free_options['color_scheme']                      		= 'default';
				$free_options['theme_scheme']                      		= 'modern';
				$free_options['wen_travel_featured_content_type']  		= 'page';
				$free_options['wen_travel_portfolio_type']     		    = 'page';
				$free_options['wen_travel_collection_type']     		= 'page';
				$free_options['wen_travel_service_type']           		= 'page';
				$free_options['wen_travel_testimonial_type']       		= 'page';
				$free_options['wen_travel_slider_type']            		= 'page';
				$free_options['wen_travel_logo_slider_type']            = 'page';
				$free_options['wen_travel_special_offer_type']          = 'page';
				$free_options['wen_travel_display_hero_content_title']  = 1;

				$color_schemes  = wen_travel_get_color_schemes();
				$color_scheme   = $color_schemes['default']['colors'];
				
				foreach ( $color_scheme as $key => $color ) {
					if ( 'background_color' === $key ) {
						$color = trim( $color, '#' );
					}

					$free_options[ $key ] = $color;
				}
			}

			if ( 'wen-travel-photography' === $old_theme_slug ) {
				$free_options['color_scheme']                      		= 'photography';
				$free_options['theme_scheme']                      		= 'photography';
				$free_options['wen_travel_featured_content_type']  		= 'page';
				$free_options['wen_travel_portfolio_type']     		    = 'page';
				$free_options['wen_travel_collection_type']     		= 'page';
				$free_options['wen_travel_service_type']           		= 'page';
				$free_options['wen_travel_testimonial_type']       		= 'page';
				$free_options['wen_travel_slider_type']            		= 'page';
				$free_options['wen_travel_logo_slider_type']            = 'page';
				$free_options['wen_travel_stats_type']          		= 'page';
				$free_options['wen_travel_display_hero_content_title']  = 1;

				$color_schemes  = wen_travel_get_color_schemes();
				$color_scheme   = $color_schemes['default']['colors'];
				
				foreach ( $color_scheme as $key => $color ) {
					if ( 'background_color' === $key ) {
						$color = trim( $color, '#' );
					}

					$free_options[ $key ] = $color;
				}
			}

			if ( 'wen-travel-corporate' === $old_theme_slug ) {
				$free_options['color_scheme']                      		= 'corporate';
				$free_options['theme_scheme']                      		= 'corporate';
				$free_options['wen_travel_header_style']		   		= 'style-two';
				$free_options['wen_travel_transparent_header']     		=  0;
				$free_options['wen_travel_featured_content_type']  		= 'page';
				$free_options['wen_travel_portfolio_type']     		    = 'page';
				$free_options['wen_travel_collection_type']     		= 'page';
				$free_options['wen_travel_service_type']           		= 'page';
				$free_options['wen_travel_testimonial_type']       		= 'page';
				$free_options['wen_travel_slider_type']            		= 'page';
				$free_options['wen_travel_logo_slider_type']            = 'page';
				$free_options['wen_travel_special_offer_type']          = 'page';
				$free_options['wen_travel_stats_type']          		= 'page';
				$free_options['wen_travel_display_hero_content_title']  = 1;

				$color_schemes  = wen_travel_get_color_schemes();
				$color_scheme   = $color_schemes['corporate']['colors'];
				
				foreach ( $color_scheme as $key => $color ) {
					if ( 'background_color' === $key ) {
						$color = trim( $color, '#' );
					}

					$free_options[ $key ] = $color;
				}
			}

			if ( update_option( 'theme_mods_' . $pro_version_slug, $free_options ) ) {
				// Set Migration Parameter to true so that this script does not run multiple times.
				set_theme_mod( 'free_pro_migration', '1' );
			}
		}
	}
}
add_action( 'after_switch_theme', 'wen_travel_setup_options' );

/**
 * Load TGMPA
 */
require_once get_parent_theme_file_path( '/inc/tgm.php' );

/**
 * Implement the Custom Header feature
 */
require get_parent_theme_file_path( '/inc/custom-header.php' );

/**
 * Custom template tags for this theme
 */
require get_parent_theme_file_path( '/inc/template-tags.php' );

/**
 * Functions which enhance the theme by hooking into WordPress
 */
require get_parent_theme_file_path( '/inc/template-functions.php' );

/**
 * Customizer additions
 */
require get_parent_theme_file_path( '/inc/customizer/customizer.php' );

/**
 * Color Scheme additions
 */
require get_parent_theme_file_path( '/inc/color-scheme.php' );

/**
 * Load Jetpack compatibility file
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_parent_theme_file_path( '/inc/jetpack.php' );
}

/**
 * Load Metabox
 */
require get_parent_theme_file_path( '/inc/metabox/metabox.php' );

/**
 * Load Social Widgets
 */
require get_parent_theme_file_path( '/inc/widgets/widget-social-icons.php' );

/**
 * Load TGMPA
 */
require get_parent_theme_file_path( '/inc/class-tgm-plugin-activation.php' );

/**
 * EDD Update Support
 */
require get_template_directory() . '/inc/updater/theme-updater.php';

/**
 * Load Theme About Page
 */
require get_parent_theme_file_path( '/inc/admin/admin.php' );

/**
 * Load WP Travel Support
 */
require get_parent_theme_file_path( '/third-party/wp-travel/functions.php' );

/**
 * Load Icon functions
 */
require get_parent_theme_file_path( '/inc/icon-functions.php' );

// Load Demo Import Class
if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) :
	require( get_template_directory() . '/inc/support/ctdi/demo-import.php' );
endif;
