<?php
/**
 * Add Collection Settings in Customizer
 *
 * @package WEN_Travel
 */

/**
 * Add portfolio options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_collection_options( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_collection', array(
			'panel'    => 'wen_travel_theme_options',
			'title'    => esc_html__( 'Collection', 'wen-travel-pro' ),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'select',
		)
	);

	$type = wen_travel_section_type_options();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_collection_active',
			'choices'           => $type,
			'label'             => esc_html__( 'Select Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_number',
			'default'           => 4,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Number of items to show', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'number',
			'input_attrs'       => array(
				'style'             => 'width: 100px;',
				'min'               => 0,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'active_callback'   => 'wen_travel_is_category_collection_active',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_collection_number', 4 );

	for ( $i = 1; $i <= $number ; $i++ ) {
		//for featured post content
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_post_collection_active',
				'input_attrs'       => array(
				'style'             => 'width: 100px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_collection',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_page_collection_active',
				'label'             => esc_html__( 'Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_collection',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Collection #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_collection',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_image_' . $i,
				'custom_control'      => 'WP_Customize_Image_Control',
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_collection',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_title_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_collection',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_sub_title_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Sub Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_collection',
				'type'              => 'text',
			)
		);

		 wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_collection',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_collection_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_image_collection_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_collection',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);
	} // End for().

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_meta_show',
			'default'           => 'show-meta',
			'active_callback'   => 'wen_travel_is_post_category_post_cpt_collection_active',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_meta_show(),
			'label'             => esc_html__( 'Display Meta', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_collection_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_collection_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_collection',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_collection_options' );

/**
 * Active Callback Functions
 */
if ( ! function_exists( 'wen_travel_is_collection_active' ) ) :
	/**
	* Return true if portfolio is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_collection_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_collection_option' )->value();

		//return true only if previwed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_collection_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_page_collection_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_page_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_category_collection_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_category_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_category_post_cpt_collection_active' ) ) :
	/**
	* Return true if page and image is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_category_post_cpt_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'page' !== $type && 'custom' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_cpt_collection_inactive' ) ) :
	/**
	* Return true if cpt is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_cpt_collection_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'jetpack-portfolio' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_image_collection_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_image_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'custom' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_itineraries_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_itineraries_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'itineraries' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_project_type_collection_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen_Travel Pro 1.0
	*/
	function wen_travel_is_project_type_collection_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_collection_type' )->value();

		return ( wen_travel_is_collection_active( $control ) && 'jetpack-portfolio-type' === $type );
	}
endif;
