<?php
/**
 * Theme Customizer
 *
 * @package WEN_Travel
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_color_scheme_register( $wp_customize ) {
	//Color Scheme
	$color_scheme = wen_travel_get_color_scheme();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'theme_scheme',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'transport'         => 'postMessage',
			'label'             => esc_html__( 'Theme Scheme', 'wen-travel-pro' ),
			'section'           => 'colors',
			'type'              => 'select',
			'choices'           => array(
				'default'     => esc_html__( 'Default', 'wen-travel-pro' ),
				'modern'      => esc_html__( 'Modern', 'wen-travel-pro' ),
				'blog'   	  => esc_html__( 'Blog', 'wen-travel-pro' ),
				'photography' => esc_html__( 'Photography', 'wen-travel-pro' ),
				'corporate'   => esc_html__( 'Corporate', 'wen-travel-pro' ),
			),
			'priority'          => 1,
			'description'       => esc_html__( 'Caution: Changing this option will change design settings like alignments, headers and menus', 'wen-travel-pro' ),
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'color_scheme',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'transport'         => 'postMessage',
			'label'             => esc_html__( 'Base Color Scheme', 'wen-travel-pro' ),
			'section'           => 'colors',
			'type'              => 'select',
			'choices'           => wen_travel_get_color_scheme_choices(),
			'priority'          => 1,
		)
	);

		wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_gradient_button',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Gradient Button', 'wen-travel-pro' ),
			'section'           => 'colors',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
			'priority'          => 14,
		)
	);

	$color_options = wen_travel_color_options();

	foreach ( $color_options as $key => $value ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => $key,
				'default'           => $color_scheme[ $key ],
				'sanitize_callback' => 'sanitize_hex_color',
				'transport'         => 'postMessage',
				'custom_control'    => 'WP_Customize_Color_Control',
				'label'             => $value['label'],
				'section'           => 'colors',
			)
		);
	}

	$wp_customize->get_control( 'header_textcolor' )->priority= 2;
	$wp_customize->get_control( 'background_color' )->priority= 4;
	$wp_customize->get_control( 'gradient_button_background_color_first' )->active_callback = 'wen_travel_is_gradient_button_enabled';
	$wp_customize->get_control( 'gradient_button_background_color_first_next' )->active_callback = 'wen_travel_is_gradient_button_enabled';
	$wp_customize->get_control( 'gradient_button_background_hover_color_first' )->active_callback = 'wen_travel_is_gradient_button_enabled';
	$wp_customize->get_control( 'gradient_button_background_hover_color_first_next' )->active_callback = 'wen_travel_is_gradient_button_enabled';
	$wp_customize->get_control( 'gradient_button_background_color_first' )->priority= 15;
	$wp_customize->get_control( 'gradient_button_background_color_first_next' )->priority= 15;
	$wp_customize->get_control( 'gradient_button_background_hover_color_first' )->priority= 15;
	$wp_customize->get_control( 'gradient_button_background_hover_color_first_next' )->priority= 15;
}
add_action( 'customize_register', 'wen_travel_color_scheme_register' );

/** Active Callback Functions */

if ( ! function_exists( 'wen_travel_is_gradient_button_enabled' ) ) :
	/**
	* Return true if gradient button is enabled
	*
	* @since Wen Travel Pro 5.0
	*/
	function wen_travel_is_gradient_button_enabled( $control ) {
		return ( $control->manager->get_setting( 'wen_travel_gradient_button' )->value() ? true : false );
	}
endif;
