<?php
/**
 * Reservation options
 *
 * @package WEN_Travel
 */

/**
 * Add Contact options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_contact_options( $wp_customize ) {
    $wp_customize->add_section( 'wen_travel_contact', array(
			'title' => esc_html__( 'Contact', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'label'             => esc_html__( 'Left Section', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'active_callback'   => 'wen_travel_is_contact_active',
        )
    );

    wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_title',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Price Title', 'wen-travel-pro' ),
			'default'           => esc_html__( 'special offer', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_currency',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Price Currency', 'wen-travel-pro' ),
			'default'           => esc_html__( '$', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_amount',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Price Amount', 'wen-travel-pro' ),
			'default'           => esc_html__( '199', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_per_person',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Per Person Text', 'wen-travel-pro' ),
			'default'           => esc_html__( 'per person', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Price Description', 'wen-travel-pro' ),
			'default'           => esc_html__( '3 nights stay at Fiji Island air fair not included', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_offer_title',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Offer Title', 'wen-travel-pro' ),
			'default'           => esc_html__( 'offer includes', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_left_offer_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Offer Listing', 'wen-travel-pro' ),
			'description'       => esc_html__( 'Set each item in new line', 'wen-travel-pro' ),
			'default'           => esc_html__( 'lorem ipsum dolor sit amet
concestetur lorem ipsum
amazing travel WP theme
lorem ipsum dolor sit amet
concestetur lorem ipsum
amazing travel WP theme', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_contact_left_offer_link_text',
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_contact_active',
            'label'             => esc_html__( 'Link Text', 'wen-travel-pro' ),
            'default'           => esc_html__( 'for more info call 1.124.567.8912', 'wen-travel-pro' ),
            'section'           => 'wen_travel_contact',
            'type'              => 'text',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_contact_left_offer_link',
            'sanitize_callback' => 'esc_url_raw',
            'active_callback'   => 'wen_travel_is_contact_active',
            'default'           => '#',
            'label'             => esc_html__( 'Link Url', 'wen-travel-pro' ),
            'section'           => 'wen_travel_contact',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_contact_left_offer_target',
            'sanitize_callback' => 'wen_travel_sanitize_checkbox',
            'active_callback'   => 'wen_travel_is_contact_active',
            'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
            'section'           => 'wen_travel_contact',
            'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );

    wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_right_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'label'             => esc_html__( 'Right Section', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'active_callback'   => 'wen_travel_is_contact_active',
        )
    );

	$type = wen_travel_section_type_options();

	unset( $type['category'] );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_type',
			'default'			=> 'page',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_contact_active',
            'choices'           => $type,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_post',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'default'           => 0,
			'active_callback'   => 'wen_travel_is_contact_post_active',
			'input_attrs'       => array(
				'style' => 'width: 40px;'
			),
			'label'             => esc_html__( 'Post', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'choices'           => wen_travel_generate_post_array(),
			'type'              => 'select'
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_page',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_contact_page_active',
			'label'             => esc_html__( 'Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'dropdown-pages',
			'allow_addition'    => true,
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_bg_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'active_callback'   => 'wen_travel_is_contact_custom_active',
			'custom_control'    => 'WP_Customize_Image_Control',
			'label'             => esc_html__( 'Background Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_title',
			'default'           => esc_html__( 'Let\'s get in touch', 'wen-travel-pro' ),
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_contact_custom_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_contact_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_contact_custom',
			'sanitize_callback' => 'wp_kses_post',
			'description'       => esc_html__( 'Add custom shortcodes from Contact Form 7 or Jetpack', 'wen-travel-pro' ),
			'active_callback'   => 'wen_travel_is_contact_custom_active',
			'label'             => esc_html__( 'Custom Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_contact',
			'type'              => 'textarea',
		)
	);
}
add_action( 'customize_register', 'wen_travel_contact_options', 10 );

if ( ! function_exists( 'wen_travel_is_contact_active' ) ) :
	/**
	* Return true if reservation is active
	*
	* @since Foodoholic Pro 1.0
	*/
	function wen_travel_is_contact_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_contact_option' )->value();

		//return true only if previewed page on customizer matches the type of content option selected
		return ( wen_travel_check_section( $enable ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_contact_post_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Foodoholic Pro 1.0
	*/
	function wen_travel_is_contact_post_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_contact_type' )->value();

		return ( wen_travel_is_contact_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_contact_page_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Foodoholic Pro 1.0
	*/
	function wen_travel_is_contact_page_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_contact_type' )->value();

		return ( wen_travel_is_contact_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_contact_custom_active' ) ) :
	/**
	* Return true if custom content is active
	*
	* @since Foodoholic Pro 1.0
	*/
	function wen_travel_is_contact_custom_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_contact_type' )->value();

		return ( wen_travel_is_contact_active( $control ) && 'custom' === $type );
	}
endif;
