<?php
/**
 * Countdown options
 *
 * @package Wen Travel Pro
 */

/**
 * Add countdown options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_countdown_options( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_countdown', array(
			'title' => esc_html__( 'Countdown', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_section_title',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Section Title', 'wen-travel-pro' ),
			'default'           => esc_html__( 'Countdown', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_section_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Section Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              		=> 'wen_travel_countdown_content_position',
			'default'           		=> 'content-align-left',
			'sanitize_callback' 		=> 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'choices'           		=> array(
				'content-align-right'  		=> esc_html__( 'Right', 'wen-travel-pro' ),
				'content-align-left'   		=> esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Position', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_text_alignment',
			'default'           => 'text-align-left',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'choices'           => array(
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_title',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_normal_price',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Normal Price', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_offer_price',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Offer Price', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_offer_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Offer Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_countdown_button_text',
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_countdown_active',
            'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
            'section'           => 'wen_travel_countdown',
            'type'              => 'text',
        )
    );

    wen_travel_register_option( $wp_customize, array(
    		'name'              => 'wen_travel_countdown_link',
    		'sanitize_callback' => 'esc_url_raw',
    		'active_callback'   => 'wen_travel_is_countdown_active',
    		'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
    		'section'           => 'wen_travel_countdown',
    	)
    );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_thumbnail_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'label'             => esc_html__( 'Thumbnail Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
		)
	);

	// Add 10 Days to current Date.
	$default = current_time( 'Y-m-d H:i:s' );
	$default = date( 'Y-m-d H:i:s', strtotime( $default . '+ 10 days') );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_countdown_end_date',
			'description'       => esc_html__( 'Must be after current date', 'wen-travel-pro' ),
			'sanitize_callback' => 'wen_travel_sanitize_date_time',
			'active_callback'   => 'wen_travel_is_countdown_active',
			'default'           => $default,
			'label'             => esc_html__( 'End Date', 'wen-travel-pro' ),
			'section'           => 'wen_travel_countdown',
			'type'              => 'date_time',
		)
	);
}
add_action( 'customize_register', 'wen_travel_countdown_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_countdown_active' ) ) :
	/**
	* Return true if countdown is active
	*
	* @since Catch Wedding Pro 1.0
	*/
	function wen_travel_is_countdown_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_countdown_option' )->value();

		return ( wen_travel_check_section( $enable ) );
	}
endif;
