<?php
/**
 * Theme Customizer
 *
 * @package WEN_Travel
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_customize_register( $wp_customize ) {
	//Color Scheme
	$color_scheme = wen_travel_get_color_scheme();

	$wp_customize->get_setting( 'blogname' )->transport              = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport       = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport      = 'postMessage';
	$wp_customize->get_setting( 'header_video' )->transport          = 'refresh';
	$wp_customize->get_setting( 'external_header_video' )->transport = 'refresh';
	$wp_customize->get_setting( 'header_image' )->transport 		 = 'refresh';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector' => '.site-title a',
			'container_inclusive' => false,
			'render_callback' => 'wen_travel_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector' => '.site-description',
			'container_inclusive' => false,
			'render_callback' => 'wen_travel_customize_partial_blogdescription',
		) );
	}

	// Important Links.
	$wp_customize->add_section( 'wen_travel_important_links', array(
		'priority'      => 999,
		'title'         => esc_html__( 'Important Links', 'wen-travel-pro' ),
	) );

	// Has dummy Sanitizaition function as it contains no value to be sanitized.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_important_links',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Important_Links_Control',
			'label'             => esc_html__( 'Important Links', 'wen-travel-pro' ),
			'section'           => 'wen_travel_important_links',
			'type'              => 'wen_travel_important_links',
		)
	);
	// Important Links End.
}
add_action( 'customize_register', 'wen_travel_customize_register', 11 );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function wen_travel_customize_preview_js() {
	$min  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	wp_enqueue_script( 'wen-travel-customize-preview', trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'js/customize-preview' . $min . '.js', array( 'customize-preview' ), date( 'Ymd-Gis', filemtime( get_template_directory() . '/' . 'js/customize-preview' . $min . '.js' ) ), true );

    $color_options = wen_travel_color_options();

    wp_localize_script( 'wen-travel-customize-preview', 'wenTravelColorOptions', $color_options );
}
add_action( 'customize_preview_init', 'wen_travel_customize_preview_js' );

/**
 * Include Custom Controls
 */
require get_parent_theme_file_path( 'inc/customizer/custom-controls.php' );

/**
 * Include Header Media Options
 */
require get_parent_theme_file_path( 'inc/customizer/header-media.php' );

/**
 * Include Color Options
 */
require get_parent_theme_file_path( 'inc/customizer/color-scheme.php' );

/**
 * Include Theme Options
 */
require get_parent_theme_file_path( 'inc/customizer/theme-options.php' );

/**
 * Include Hero Content
 */
require get_parent_theme_file_path( 'inc/customizer/hero-content.php' );

/**
 * Include Special Offer
 */
require get_parent_theme_file_path( 'inc/customizer/special-offer.php' );

/**
 * Include Featured Slider
 */
require get_parent_theme_file_path( 'inc/customizer/featured-slider.php' );

/**
 * Include Featured Content
 */
require get_parent_theme_file_path( 'inc/customizer/featured-content.php' );

/**
 * Include Testimonial
 */
require get_parent_theme_file_path( 'inc/customizer/testimonial.php' );

/**
 * Include Promotion Headline
 */
require get_parent_theme_file_path( 'inc/customizer/promotion-headline.php' );

/**
 * Include Promotion Headline Two
 */
require get_parent_theme_file_path( 'inc/customizer/promotion-headline-two.php' );

/**
 * Include Portfolio
 */
require get_parent_theme_file_path( 'inc/customizer/portfolio.php' );

/**
 * Include Portfolio Two
 */
require get_parent_theme_file_path( 'inc/customizer/portfolio-two.php' );

/**
 * Include Collection
 */
require get_parent_theme_file_path( 'inc/customizer/collection.php' );

/**
 * Include Collection
 */
require get_parent_theme_file_path( 'inc/customizer/attraction.php' );

/**
 * Include WooCommerce Support
 */
require get_parent_theme_file_path( 'inc/customizer/woocommerce.php' );

/**
 * Include Customizer Helper Functions
 */
require get_parent_theme_file_path( 'inc/customizer/helpers.php' );

/**
 * Include Sanitization functions
 */
require get_parent_theme_file_path( 'inc/customizer/sanitize-functions.php' );

/**
 * Include Team
 */
require get_parent_theme_file_path( 'inc/customizer/team.php' );

/**
 * Include Gallery Section
 */
require get_parent_theme_file_path( 'inc/customizer/gallery.php' );

/**
 * Include Service
 */
require get_parent_theme_file_path( 'inc/customizer/service.php' );

/**
 * Include Stats
 */
require get_parent_theme_file_path( 'inc/customizer/stats.php' );

/**
 * Include Reset Button
 */
require get_parent_theme_file_path( 'inc/customizer/reset.php' );

/**
 * Include Logo Slider
 */
require get_parent_theme_file_path( 'inc/customizer/logo-slider.php' );

/**
 * Include Contact Section
 */
require get_parent_theme_file_path( 'inc/customizer/contact.php' );

/**
 * Include Header Top
 */
require get_parent_theme_file_path( 'inc/customizer/header-top.php' );

/**
 * Include Countdown
 */
require get_parent_theme_file_path( 'inc/customizer/countdown.php' );

/**
 * Include Latest Package
 */
require get_parent_theme_file_path( 'inc/customizer/latest-package.php' );
