<?php
/**
 * Featured Content options
 *
 * @package WEN_Travel
 */

/**
 * Add featured content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_featured_content_options( $wp_customize ) {
	// Add note to ECT Featured Content Section
    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_featured_content_jetpack_note',
            'sanitize_callback' => 'sanitize_text_field',
            'custom_control'    => 'Wen_Travel_Note_Control',
            'label'             => sprintf( esc_html__( 'For all Featured Content Options for Wen Travel Pro Theme, go %1$shere%2$s', 'wen-travel-pro' ),
                '<a href="javascript:wp.customize.section( \'wen_travel_featured_content\' ).focus();">',
                 '</a>'
            ),
           'section'            => 'featured_content',
            'type'              => 'description',
            'priority'          => 1,
        )
    );

    $wp_customize->add_section( 'wen_travel_featured_content', array(
			'title' => esc_html__( 'Featured Content', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_layout',
			'default'           => 'layout-three',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_featured_content_active',
			'choices'           => wen_travel_sections_layout_options(),
			'label'             => esc_html__( 'Select Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_featured_page_post_category_image_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_featured_page_post_category_image_content_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'textarea',
		)
	);

	$type = wen_travel_section_type_options();

	$type['featured-content'] = esc_html__( 'Custom Post Type', 'wen-travel-pro' );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_featured_content_active',
			'description'       => sprintf( esc_html__( 'For Custom Post Type Content, install %1$sEssential Content Types%2$s Plugin with Featured Content Type Enabled', 'wen-travel-pro' ),
                '<a target="_blank" href="https://wordpress.org/plugins/essential-content-types/">',
                '</a>'
            ),
            'choices'           => $type,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_thumbnail_style',
			'default'           => 'style-one',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_featured_content_active',
			'choices'           => array(
			'style-one'        => esc_html__( 'Style 1', 'wen-travel-pro' ),
			'style-two'        => esc_html__( 'Style 2', 'wen-travel-pro' ),
		),
			'label'             => esc_html__( 'Thumbnail Style', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'select',
		)
	);

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_featured_content_cpt_note',
            'sanitize_callback' => 'sanitize_text_field',
            'custom_control'    => 'Wen_Travel_Note_Control',
            'active_callback'   => 'wen_travel_is_featured_cpt_content_active',
            'label'             => sprintf( esc_html__( 'For CPT heading and sub-heading, go %1$shere%2$s', 'wen-travel-pro' ),
                 '<a href="javascript:wp.customize.control( \'featured_content_title\' ).focus();">',
                 '</a>'
            ),
            'section'           => 'wen_travel_featured_content',
            'type'              => 'description',
        )
    );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_number',
			'default'           => 3,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_featured_content_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Featured Content is changed (Max no of Featured Content is 20)', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'No of Featured Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'number',
			'transport'         => 'postMessage',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_featured_post_category_cpt_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_featured_content',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_featured_content_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_featured_category_content_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_featured_content_select_category',
			'section'           => 'wen_travel_featured_content',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_featured_content_number', 3 );

	//loop for featured post content
	for ( $i = 1; $i <= $number ; $i++ ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'default'           => 0,
				'active_callback'   => 'wen_travel_is_featured_post_content_active',
				'input_attrs'       => array(
					'style'             => 'width: 40px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_featured_content',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select'
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_featured_page_content_active',
				'label'             => esc_html__( 'Featured Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_featured_content',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_cpt_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_featured_cpt_content_active',
				'label'             => esc_html__( 'Featured Content', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_featured_content',
				'type'              => 'select',
                'choices'           => wen_travel_generate_post_array( 'featured-content' ),
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Featured Content #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_featured_content',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_featured_content',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_featured_content',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_featured_content',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_title_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_featured_content',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_featured_content_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_featured_image_content_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_featured_content',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
	            'name'              => 'wen_travel_featured_content_button_text_' . $i,
	            'sanitize_callback' => 'sanitize_text_field',
	            'active_callback'   => 'wen_travel_is_featured_image_content_active',
	            'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
	            'section'           => 'wen_travel_featured_content',
	            'type'              => 'text',
	        )
	    );
	} // End for().

	wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_featured_content_text',
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_featured_content_active',
            'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
            'section'           => 'wen_travel_featured_content',
            'type'              => 'text',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_featured_content_link',
            'sanitize_callback' => 'esc_url_raw',
            'active_callback'   => 'wen_travel_is_featured_content_active',
            'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
            'section'           => 'wen_travel_featured_content',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_featured_content_target',
            'sanitize_callback' => 'wen_travel_sanitize_checkbox',
            'active_callback'   => 'wen_travel_is_featured_content_active',
            'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
            'section'           => 'wen_travel_featured_content',
            'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );
}
add_action( 'customize_register', 'wen_travel_featured_content_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_featured_content_active' ) ) :
	/**
	* Return true if featured content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_content_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_featured_content_option' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_post_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_page_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_cpt_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && 'featured-content' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && ( 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_page_post_category_image_content_active' ) ) :
	/**
	* Return true if page/post/category/image content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_page_post_category_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && ( 'custom' === $type || 'category' === $type || 'page' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_post_category_cpt_content_active' ) ) :
	/**
	* Return true if page/post/category/image content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_post_category_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && ( 'category' === $type || 'post' === $type || 'featured-content' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_featured_image_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_featured_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_featured_content_type' )->value();

		return ( wen_travel_is_featured_content_active( $control ) && 'custom' === $type );
	}
endif;
