<?php
/**
 * Header Media Options
 *
 * @package WEN_Travel
 */

/**
 * Add Header Media options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_header_media_options( $wp_customize ) {
	$wp_customize->get_section( 'header_image' )->description = esc_html__( 'If you add video, it will only show up on Homepage/FrontPage. Other Pages will use Header/Post/Page Image depending on your selection of option. Header Image will be used as a fallback while the video loads ', 'wen-travel-pro' );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_option',
			'default'           => 'entire-site',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => array(
				'homepage'               => esc_html__( 'Homepage / Frontpage', 'wen-travel-pro' ),
				'exclude-home'           => esc_html__( 'Excluding Homepage', 'wen-travel-pro' ),
				'exclude-home-page-post' => esc_html__( 'Excluding Homepage, Page/Post Featured Image', 'wen-travel-pro' ),
				'entire-site'            => esc_html__( 'Entire Site', 'wen-travel-pro' ),
				'entire-site-page-post'  => esc_html__( 'Entire Site, Page/Post Featured Image', 'wen-travel-pro' ),
				'pages-posts'            => esc_html__( 'Pages and Posts', 'wen-travel-pro' ),
				'disable'                => esc_html__( 'Disabled', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'select',
			'priority'          => 1,
		)
	);

	/*Overlay Option for Header Media*/
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_image_opacity',
			'default'           => '0',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'label'             => esc_html__( 'Header Media Overlay', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'number',
			'input_attrs'       => array(
				'style' => 'width: 60px;',
				'min'   => 0,
				'max'   => 100,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_text_alignment',
			'default'           => 'text-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_content_alignment',
			'default'           => 'content-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => array(
				'content-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'content-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'content-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Alignment', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_logo',
			'sanitize_callback' => 'esc_url_raw',
			'custom_control'    => 'WP_Customize_Image_Control',
			'label'             => esc_html__( 'Header Media Logo', 'wen-travel-pro' ),
			'section'           => 'header_image',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_logo_option',
			'default'           => 'homepage',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_header_media_logo_active',
			'choices'           => array(
				'homepage'               => esc_html__( 'Homepage / Frontpage', 'wen-travel-pro' ),
				'entire-site'            => esc_html__( 'Entire Site', 'wen-travel-pro' ) ),
			'label'             => esc_html__( 'Enable Header Media logo on', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_tagline',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Header Media Tagline', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_title',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Header Media Title', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'text',
		)
	);

    wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_text',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Site Header Text', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_url',
			'default'           => '#',
			'sanitize_callback' => 'esc_url_raw',
			'label'             => esc_html__( 'Header Media Url', 'wen-travel-pro' ),
			'section'           => 'header_image',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_media_url_text',
			'sanitize_callback' => 'sanitize_text_field',
			'label'             => esc_html__( 'Header Media Url Text', 'wen-travel-pro' ),
			'section'           => 'header_image',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_url_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_url_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_content_frame',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Add frame to content', 'wen-travel-pro' ),
			'section'           => 'header_image',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_header_media_options' );

/** Active Callback Functions */

if ( ! function_exists( 'wen_travel_is_header_media_logo_active' ) ) :
	/**
	* Return true if header logo is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_header_media_logo_active( $control ) {
		$logo = $control->manager->get_setting( 'wen_travel_header_media_logo' )->value();
		if ( '' != $logo ) {
			return true;
		} else {
			return false;
		}
	}
endif;
