<?php
/**
 * Hero Content Options
 *
 * @package WEN_Travel
 */

/**
 * Add hero content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_hero_content_options( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_hero_content_options', array(
			'title' => esc_html__( 'Hero Content', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_visibility',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'select',
		)
	);

	$types = wen_travel_section_type_options();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_type',
			'default'           => 'page',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'choices'           => $types,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content',
			'default'           => '0',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_hero_page_content_active',
			'label'             => esc_html__( 'Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'dropdown-pages',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_post',
			'default'           => 0,
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_hero_post_content_active',
			'label'             => esc_html__( 'Post', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'choices'           => wen_travel_generate_post_array(),
			'type'              => 'select',
		)
	);

	// create an empty array.
	$cats = array();

	$cats['0'] = esc_html__( '-- Select --', 'wen-travel-pro' );

	// we loop over the categories and set the names and
	// labels we need.
	foreach ( get_categories() as $categories => $category ) {
		$cats[ $category->term_id ] = $category->name;
	}

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_category',
			'default'           => '0',
			'sanitize_callback' => 'absint',
			'active_callback'   => 'wen_travel_is_hero_category_content_active',
			'label'             => esc_html__( 'Category', 'wen-travel-pro' ),
			'type'              => 'select',
			'choices'           => $cats,
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_content',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Image Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_display_hero_content_title',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_hero_post_page_category_content_active',
			'label'             => esc_html__( 'Display Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_show',
			'default'           => 'full-content',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_hero_post_page_category_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_img_align',
			'default'           => 'content-align-right',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'choices'           => array(
				'content-align-right' => esc_html__( 'Right', 'wen-travel-pro' ),
				'content-align-left'  => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_txt_align',
			'default'           => 'text-align-left',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_more_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_more_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_more_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_hero_custom_content_active',
			'label'             => esc_html__( 'Check to Open Button Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_video_title',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'label'             => esc_html__( 'Video Title', 'wen-travel-pro' ),
			'default'           => esc_html__( 'Watch Our Video', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_hero_content_video_subtitle',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_hero_content_active',
			'label'             => esc_html__( 'Video Subtitle', 'wen-travel-pro' ),
			'default'           => esc_html__( 'The Beauty Of Ocean Tour', 'wen-travel-pro' ),
			'section'           => 'wen_travel_hero_content_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_hero_content_video_link',
            'sanitize_callback' => 'esc_url_raw',
            'active_callback'   => 'wen_travel_is_hero_content_active',
            'label'             => esc_html__( 'Video Url', 'wen-travel-pro' ),
            'description'       => esc_html__( 'Provide a valid Video URL like a Youtube Video Link', 'wen-travel-pro' ),
            'section'           => 'wen_travel_hero_content_options',
	        )
	);
}
add_action( 'customize_register', 'wen_travel_hero_content_options' );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_hero_content_active' ) ) :
	/**
	* Return true if hero content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_content_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_hero_content_visibility' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_hero_post_content_active' ) ) :
	/**
	* Return true if post content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_hero_content_type' )->value();

		return ( wen_travel_is_hero_content_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_hero_page_content_active' ) ) :
	/**
	* Return true if hero page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_hero_content_type' )->value();

		return ( wen_travel_is_hero_content_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_hero_category_content_active' ) ) :
	/**
	* Return true if hero category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_hero_content_type' )->value();

		return ( wen_travel_is_hero_content_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_hero_post_page_category_content_active' ) ) :
	/**
	* Return true if hero post/page/category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_post_page_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_hero_content_type' )->value();

		return ( wen_travel_is_hero_content_active( $control ) && ( 'page' === $type || 'post' === $type || 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_hero_custom_content_active' ) ) :
	/**
	* Return true if hero custom content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_hero_custom_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_hero_content_type' )->value();

		return ( wen_travel_is_hero_content_active( $control ) && 'custom' === $type );
	}
endif;
