<?php
/**
 * Latest Package options
 *
 * @package WEN_Travel
 */

/**
 * Add featured content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_latest_package_options( $wp_customize ) {
    $wp_customize->add_section( 'wen_travel_latest_package', array(
			'title' => esc_html__( 'Latest Package', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_latest_trip_page_post_category_image_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_latest_trip_page_post_category_image_content_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'textarea',
		)
	);

	$type = wen_travel_section_type_options();

	if ( class_exists( 'WP_Travel' ) ) {
	    $type['itineraries'] = esc_html__( 'Trips (WP Travel)', 'wen-travel-pro' );
	    $type['destination'] = esc_html__( 'Destination filter (WP Travel)', 'wen-travel-pro' );
	}

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_latest_package_active',
            'choices'           => $type,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_number',
			'default'           => 3,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_latest_package_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Latest Package is changed (Max no of Latest Package is 20)', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'No of Latest Package', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'number',
			'transport'         => 'postMessage',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_latest_trip_post_category_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_latest_trip_category_content_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_latest_package_select_category',
			'section'           => 'wen_travel_latest_package',
			'type'              => 'dropdown-categories',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_package_select_destination',
			'sanitize_callback' => 'wen_travel_sanitize_multi_type',
			'active_callback'   => 'wen_travel_is_latest_trip_destination_active',
			'custom_control'    => 'Wen_Travel_Multi_Destination',
			'label'             => esc_html__( 'Select Destinations', 'wen-travel-pro' ),
			'section'           => 'wen_travel_latest_package',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_latest_package_number', 3 );

	//loop for featured post content
	for ( $i = 1; $i <= $number ; $i++ ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'default'           => 0,
				'active_callback'   => 'wen_travel_is_latest_package_post_content_active',
				'input_attrs'       => array(
					'style'             => 'width: 40px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_latest_package',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select'
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_latest_trip_page_content_active',
				'label'             => esc_html__( 'Featured Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_latest_package',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_itineraries_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_latest_trip_itineraries_active',
				'label'             => esc_html__( 'Trip', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_latest_package',
				'type'              => 'select',
				'choices'           => wen_travel_generate_post_array( 'itineraries' ),
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Latest Package #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_latest_package',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_latest_package',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_latest_package',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_latest_package',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_title_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_latest_package',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_latest_package_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_latest_trip_image_content_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_latest_package',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
	            'name'              => 'wen_travel_latest_package_price_text' . $i,
	            'sanitize_callback' => 'sanitize_text_field',
	            'active_callback'   => 'wen_travel_is_latest_trip_destination_itineraries_active',
	            'label'             => esc_html__( 'Price Text #', 'wen-travel-pro' ) . $i,
	            'section'           => 'wen_travel_latest_package',
	            'type'              => 'text',
	        )
	    );

    	wen_travel_register_option( $wp_customize, array(
                'name'              => 'wen_travel_latest_package_price_amount' . $i,
                'sanitize_callback' => 'sanitize_text_field',
                'active_callback'   => 'wen_travel_is_latest_trip_destination_itineraries_active',
                'label'             => esc_html__( 'Price Amount #', 'wen-travel-pro' ) . $i,
                'section'           => 'wen_travel_latest_package',
                'type'              => 'text',
            )
        );

    	wen_travel_register_option( $wp_customize, array(
                'name'              => 'wen_travel_latest_package_button_text_' . $i,
                'sanitize_callback' => 'sanitize_text_field',
                'active_callback'   => 'wen_travel_is_latest_trip_destination_itineraries_active',
                'label'             => esc_html__( 'Button Text #', 'wen-travel-pro' ) . $i,
                'section'           => 'wen_travel_latest_package',
                'type'              => 'text',
            )
        );

        wen_travel_register_option( $wp_customize, array(
		'name'              => 'wen_travel_latest_package_button_link_' . $i,
		'sanitize_callback' => 'esc_url_raw',
       		'active_callback'   => 'wen_travel_is_latest_trip_destination_itineraries_active',
		'label'             => esc_html__( 'Button Link #', 'wen-travel-pro' ) . $i,
		'section'           => 'wen_travel_latest_package',
	)
);
	} // End for().
}
add_action( 'customize_register', 'wen_travel_latest_package_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_latest_package_active' ) ) :
	/**
	* Return true if featured content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_package_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_latest_package_option' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_package_post_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_package_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_page_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && ( 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_page_post_category_image_content_active' ) ) :
	/**
	* Return true if page/post/category/image content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_page_post_category_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && ( 'custom' === $type || 'category' === $type || 'page' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_post_category_content_active' ) ) :
	/**
	* Return true if page/post/category/image content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_post_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && ( 'category' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_image_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'custom' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_destination_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_destination_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'destination' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_itineraries_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_itineraries_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'itineraries' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_latest_trip_destination_itineraries_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_latest_trip_destination_itineraries_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_latest_package_type' )->value();

		return ( wen_travel_is_latest_package_active( $control ) && 'destination' !== $type && 'itineraries' !== $type );
	}
endif;
