<?php
/**
 * Featured Slider Options
 *
 * @package WEN_Travel
 */

/**
 * Add hero content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_logo_slider_options( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_logo_slider', array(
			'panel' => 'wen_travel_theme_options',
			'title' => esc_html__( 'Logo Slider', 'wen-travel-pro' ),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_layout',
			'default'           => 5,
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'choices'           => array(
				'1' => esc_html__( '1 column', 'wen-travel-pro' ),
				'2' => esc_html__( '2 columns', 'wen-travel-pro' ),
				'3' => esc_html__( '3 columns', 'wen-travel-pro' ),
				'4' => esc_html__( '4 columns', 'wen-travel-pro' ),
				'5' => esc_html__( '5 columns', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Select Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_subtitle',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Subtitle', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_transition_in',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_logo_slider_layout_1',
			'choices'           => wen_travel_transition_effects(),
			'label'             => esc_html__( 'Transition In', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_transition_out',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_logo_slider_layout_1',
			'choices'           => wen_travel_transition_effects(),
			'label'             => esc_html__( 'Transition Out', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_nav',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Display nav arrows', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_dots',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Display nav dots', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_autoplay',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'Autoplay', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_loop',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'label'             => esc_html__( 'loop (Last to first)', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_transition_timeout',
			'default'           => 4,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'Transition timeout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'number',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'choices'           => wen_travel_section_type_options(),
			'label'             => esc_html__( 'Select Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_number',
			'default'           => '6',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',

			'active_callback'   => 'wen_travel_is_logo_slider_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Items is changed (Max no of slides is 20)', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
				'max'   => 20,
				'step'  => 1,
			),
			'label'             => esc_html__( 'No of Items', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'number',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_content_show',
			'default'           => 'hide-content',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_image_logo_slider_inactive',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_logo_slider_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_category_logo_slider_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_logo_slider_select_category',
			'section'           => 'wen_travel_logo_slider',
			'type'              => 'dropdown-categories',
		)
	);

	$logo_slider_number = get_theme_mod( 'wen_travel_logo_slider_number', 6 );

	for ( $i = 1; $i <= $logo_slider_number ; $i++ ) {
		// Post Sliders
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_post_logo_slider_active',
				'input_attrs'       => array(
					'style' => 'width: 80px;',
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' # ' . $i,
				'section'           => 'wen_travel_logo_slider',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select',
			)
		);

		// Page Sliders
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_page_logo_slider_active',
				'label'             => esc_html__( 'Page', 'wen-travel-pro' ) . ' # ' . $i,
				'section'           => 'wen_travel_logo_slider',
				'type'              => 'dropdown-pages',
			)
		);

		// Image Sliders
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Item #', 'wen-travel-pro' ) . $i,
				'section'           => 'wen_travel_logo_slider',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_logo_slider',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_logo_slider',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_logo_slider',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_title_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_logo_slider',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_logo_slider_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_image_logo_slider_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_logo_slider',
				'type'              => 'textarea',
			)
		);
	} // End for().
}
add_action( 'customize_register', 'wen_travel_logo_slider_options' );

/** Active Callback Functions */

if ( ! function_exists( 'wen_travel_is_logo_slider_active' ) ) :
	/**
	* Return true if logo_slider is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_logo_slider_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_logo_slider_option' )->value();

		//return true only if previwed page on customizer matches the type option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_layout_2_logo_slider_inactive' ) ) :
	/**
	* Return true if layout 2 is not selected
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_layout_2_logo_slider_inactive( $control ) {
		$layout = $control->manager->get_setting( 'wen_travel_logo_slider_layout' )->value();

		return ( wen_travel_is_logo_slider_active( $control ) && 'layout-2' !== $layout );
	}
endif;

if ( ! function_exists( 'wen_travel_is_logo_slider_layout_1' ) ) :
	/**
	* Return true layout 1 is selected
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_logo_slider_layout_1( $control ) {
		$layout = $control->manager->get_setting( 'wen_travel_logo_slider_layout' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 1 === $layout );
	}
endif;


if ( ! function_exists( 'wen_travel_is_post_logo_slider_active' ) ) :
	/**
	* Return true if page logo_slider is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_post_logo_slider_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_logo_slider_type' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 'post' === $type );
	}
endif;


if ( ! function_exists( 'wen_travel_is_page_logo_slider_active' ) ) :
	/**
	* Return true if page logo_slider is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_page_logo_slider_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_logo_slider_type' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 'page' === $type );
	}
endif;


if ( ! function_exists( 'wen_travel_is_category_logo_slider_active' ) ) :
	/**
	* Return true if page logo_slider is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_category_logo_slider_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_logo_slider_type' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_image_logo_slider_active' ) ) :
	/**
	* Return true if page logo_slider is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_image_logo_slider_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_logo_slider_type' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 'custom' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_image_logo_slider_inactive' ) ) :
	/**
	* Return true if page logo_slider is inactive
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_image_logo_slider_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_logo_slider_type' )->value();

		//return true only if previwed page on customizer matches the type of logo_slider option selected and is or is not selected type
		return ( wen_travel_is_logo_slider_active( $control ) && 'custom' !== $type );
	}
endif;
