<?php
/**
 * Add Portfolio Settings in Customizer
 *
 * @package WEN_Travel
 */

/**
 * Add portfolio options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_portfolio_options( $wp_customize ) {
	// Add note to Jetpack Portfolio Section
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_jetpack_portfolio_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'label'             => sprintf( esc_html__( 'For Portfolio Options for Wen Travel Pro Theme, go %1$shere%2$s', 'wen-travel-pro' ),
				 '<a href="javascript:wp.customize.section( \'wen_travel_portfolio\' ).focus();">',
				 '</a>'
			),
			'section'           => 'jetpack_portfolio',
			'type'              => 'description',
			'priority'          => 1,
		)
	);

	$wp_customize->add_section( 'wen_travel_portfolio', array(
			'panel'    => 'wen_travel_theme_options',
			'title'    => esc_html__( 'Portfolio', 'wen-travel-pro' ),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'select',
		)
	);
	
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_layout',
			'default'           => 'layout-three',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'choices'           => wen_travel_portfolio_layout_options(),
			'label'             => esc_html__( 'Select Portfolio Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'select',
		)
	);

	$type = wen_travel_section_type_options();

	if ( class_exists( 'WP_Travel' ) ) {
	    $type['itineraries'] = esc_html__( 'Trips (WP Travel)', 'wen-travel-pro' );
	    $type['destination'] = esc_html__( 'Destination filter (WP Travel)', 'wen-travel-pro' );
	}

	$type['cpt']                    = esc_html__( 'CPT (Essential Content Types)', 'wen-travel-pro' );
	$type['jetpack-portfolio-type'] = esc_html__( 'CPT - Project Types Filter (Essential Content Types)', 'wen-travel-pro' );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'choices'           => $type,
			'description'       => sprintf( esc_html__( 'For Custom Post Type Content, install %1$sEssential Content Types%2$s Plugin with Portfolio Content Type Enabled', 'wen-travel-pro' ),
				'<a target="_blank" href="https://wordpress.org/plugins/essential-content-types/">',
				'</a>'
			),
			'label'             => esc_html__( 'Select Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_bg_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'label'             => esc_html__( 'Background Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'active_callback'   => 'wen_travel_is_jetpack_portfolio_active',
			'label'             => sprintf( esc_html__( 'For CPT heading and sub-heading, go %1$shere%2$s', 'wen-travel-pro' ),
				 '<a href="javascript:wp.customize.control( \'jetpack_portfolio_title\' ).focus();">',
				 '</a>'
			),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'description',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_portfolio_inactive',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_portfolio_inactive',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_number',
			'default'           => 6,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'label'             => esc_html__( 'Number of items to show', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'number',
			'input_attrs'       => array(
				'style'             => 'width: 100px;',
				'min'               => 0,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'active_callback'   => 'wen_travel_is_category_portfolio_active',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'dropdown-categories',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_select_destination',
			'sanitize_callback' => 'wen_travel_sanitize_multi_type',
			'active_callback'   => 'wen_travel_is_destination_portfolio_active',
			'custom_control'    => 'Wen_Travel_Multi_Destination',
			'label'             => esc_html__( 'Select Destinations', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'dropdown-categories',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_select_project_type',
			'sanitize_callback' => 'wen_travel_sanitize_multi_type',
			'active_callback'   => 'wen_travel_is_project_type_portfolio_active',
			'custom_control'    => 'Wen_Travel_Multi_Cat_Project_Type',
			'label'             => esc_html__( 'Select Project Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
		)
	);

	$number = get_theme_mod( 'wen_travel_portfolio_number', 6 );

	for ( $i = 1; $i <= $number ; $i++ ) {
		//for featured post content
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_post_portfolio_active',
				'input_attrs'       => array(
				'style'             => 'width: 100px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_portfolio',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select',
			)
		);

		//for CPT
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_cpt_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_jetpack_portfolio_active',
				'label'             => esc_html__( 'Portfolio', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_portfolio',
				'type'              => 'select',
				'choices'           => wen_travel_generate_post_array( 'jetpack-portfolio' ),
			)
		);

		//for trip
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_itineraries_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_itineraries_active',
				'label'             => esc_html__( 'Trip', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_portfolio',
				'type'              => 'select',
				'choices'           => wen_travel_generate_post_array( 'itineraries' ),
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_page_portfolio_active',
				'label'             => esc_html__( 'Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_portfolio',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_image_portfolio_active',
				'label'             => esc_html__( 'Portfolio #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_portfolio',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_image_' . $i,
				'custom_control'      => 'WP_Customize_Image_Control',
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'active_callback'   => 'wen_travel_is_image_portfolio_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_portfolio',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_title_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_portfolio_active',
				'label'             => esc_html__( 'Name', 'wen-travel-pro' ),
				'section'           => 'wen_travel_portfolio',
				'type'              => 'text',
			)
		);

		 wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_image_portfolio_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_portfolio',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_portfolio_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_image_portfolio_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_portfolio',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);
	} // End for().

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_meta_show',
			'default'           => 'show-meta',
			'active_callback'   => 'wen_travel_is_post_category_post_cpt_portfolio_active',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_meta_show(),
			'label'             => esc_html__( 'Display Meta', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_portfolio_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_portfolio_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_portfolio',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_portfolio_options' );

/**
 * Active Callback Functions
 */
if ( ! function_exists( 'wen_travel_is_portfolio_active' ) ) :
	/**
	* Return true if portfolio is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_portfolio_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_portfolio_option' )->value();

		//return true only if previwed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_jetpack_portfolio_active' ) ) :
	/**
	* Return true if jetpack portfolio is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_jetpack_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'cpt' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_page_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_page_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_category_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_category_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_destination_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_destination_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'destination' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_category_post_cpt_portfolio_active' ) ) :
	/**
	* Return true if page and image is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_category_post_cpt_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'page' !== $type && 'custom' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_cpt_portfolio_inactive' ) ) :
	/**
	* Return true if cpt is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_cpt_portfolio_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'cpt' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_image_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_image_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'custom' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_itineraries_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_itineraries_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'itineraries' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_project_type_portfolio_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen_Travel Pro 1.0
	*/
	function wen_travel_is_project_type_portfolio_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_portfolio_type' )->value();

		return ( wen_travel_is_portfolio_active( $control ) && 'jetpack-portfolio-type' === $type );
	}
endif;
