<?php
/**
 * Promotion Headline Options
 *
 * @package WEN_Travel
 */

/**
 * Add promotion headline options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_promo_head_two( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_promo_head_two', array(
			'title' => esc_html__( 'Promotion Headline Two', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_visibility',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'select',
		)
	);

	$types = wen_travel_section_type_options();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_type',
			'default'           => 'page',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback' 	=> 'wen_travel_is_promo_head_two_active',
			'choices'         	=> $types,
			'label'           	=> esc_html__( 'Type', 'wen-travel-pro' ),
			'section'         	=> 'wen_travel_promo_head_two',
			'type'            	=> 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_image_position',
			'default'           => 'content-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_two_active',
			'choices'           => array(
				'content-align-right'  => esc_html__( 'Right Align', 'wen-travel-pro' ),
				'content-align-left'   => esc_html__( 'Left Align', 'wen-travel-pro' ),
				'content-align-center' => esc_html__( 'Center Align', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Position', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_text_alignment',
			'default'           => 'text-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_two_active',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'radio',
		)
	);

	/*Overlay Option for Promotion Headline Background Image */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_background_image_opacity',
			'default'           => '50',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_promo_head_two_active',
			'label'             => esc_html__( 'Background Image Overlay', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'number',
			'input_attrs'       => array(
				'style' => 'width: 60px;',
				'min'   => 0,
				'max'   => 100,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_text_color',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_two_active',
			'label'             => esc_html__( 'Display text in white color', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two',
			'default'           => '0',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_promo_head_two_page_content_active',
			'label'             => esc_html__( 'Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'dropdown-pages',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_post',
			'default'           => 0,
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_promo_head_two_post_content_active',
			'label'             => esc_html__( 'Post', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'choices'           => wen_travel_generate_post_array(),
			'type'              => 'select',
		)
	);

	// create an empty array.
	$cats = array();

	$cats['0'] = esc_html__( '-- Select --', 'wen-travel-pro' );

	// we loop over the categories and set the names and
	// labels we need.
	foreach ( get_categories() as $categories => $category ) {
		$cats[ $category->term_id ] = $category->name;
	}

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_category',
			'default'           => '0',
			'sanitize_callback' => 'absint',
			'active_callback'   => 'wen_travel_is_promo_head_two_category_content_active',
			'label'             => esc_html__( 'Category', 'wen-travel-pro' ),
			'type'              => 'select',
			'choices'           => $cats,
			'section'           => 'wen_travel_promo_head_two',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_two_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_content',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Background Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Background Image Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_more_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_more_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_more_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_two_custom_content_active',
			'label'             => esc_html__( 'Check to Open Button Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_display_promo_head_two_title',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_two_post_page_category_product_content_active',
			'label'             => esc_html__( 'Display title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_two_show',
			'default'           => 'full-content',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_two_post_page_category_product_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head_two',
			'type'              => 'select',
		)
	);
}
add_action( 'customize_register', 'wen_travel_promo_head_two' );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_promo_head_two_active' ) ) :
	/**
	* Return true if promotion headline is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_promo_head_two_visibility' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_post_content_active' ) ) :
	/**
	* Return true if post content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_page_content_active' ) ) :
	/**
	* Return true if promotion headline page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_category_content_active' ) ) :
	/**
	* Return true if promotion headline category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_post_page_category_product_content_active' ) ) :
	/**
	* Return true if promotion headline post/page/category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_post_page_category_product_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && ( 'page' === $type || 'post' === $type || 'category' === $type || 'product' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_custom_content_active' ) ) :
	/**
	* Return true if promotion headline custom content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_custom_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && ( 'custom' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_two_product_content_active' ) ) :
	/**
	* Return true if promotion headline product content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_two_product_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_two_type' )->value();

		return ( wen_travel_is_promo_head_two_active( $control ) && ( 'product' === $type ) );
	}
endif;
