<?php
/**
 * Promotion Headline Options
 *
 * @package WEN_Travel
 */

/**
 * Add promotion headline options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_promo_head( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_promo_head', array(
			'title' => esc_html__( 'Promotion Headline', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_visibility',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'select',
		)
	);

	$types = wen_travel_section_type_options();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_type',
			'default'           => 'page',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback' 	=> 'wen_travel_is_promo_head_active',
			'choices'         	=> $types,
			'label'           	=> esc_html__( 'Type', 'wen-travel-pro' ),
			'section'         	=> 'wen_travel_promo_head',
			'type'            	=> 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_image_position',
			'default'           => 'content-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_active',
			'choices'           => array(
				'content-align-right'  => esc_html__( 'Right Align', 'wen-travel-pro' ),
				'content-align-left'   => esc_html__( 'Left Align', 'wen-travel-pro' ),
				'content-align-center' => esc_html__( 'Center Align', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Position', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_text_alignment',
			'default'           => 'text-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_active',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'radio',
		)
	);

	/*Overlay Option for Promotion Headline Background Image */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_background_image_opacity',
			'default'           => '50',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_promo_head_active',
			'label'             => esc_html__( 'Background Image Overlay', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'number',
			'input_attrs'       => array(
				'style' => 'width: 60px;',
				'min'   => 0,
				'max'   => 100,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_text_color',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_active',
			'label'             => esc_html__( 'Display text in white color', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head',
			'default'           => '0',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_promo_head_page_content_active',
			'label'             => esc_html__( 'Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'dropdown-pages',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_post',
			'default'           => 0,
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_promo_head_post_content_active',
			'label'             => esc_html__( 'Post', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'choices'           => wen_travel_generate_post_array(),
			'type'              => 'select',
		)
	);

	// create an empty array.
	$cats = array();

	$cats['0'] = esc_html__( '-- Select --', 'wen-travel-pro' );

	// we loop over the categories and set the names and
	// labels we need.
	foreach ( get_categories() as $categories => $category ) {
		$cats[ $category->term_id ] = $category->name;
	}

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_category',
			'default'           => '0',
			'sanitize_callback' => 'absint',
			'active_callback'   => 'wen_travel_is_promo_head_category_content_active',
			'label'             => esc_html__( 'Category', 'wen-travel-pro' ),
			'type'              => 'select',
			'choices'           => $cats,
			'section'           => 'wen_travel_promo_head',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_content',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Background Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Background Image Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_more_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_more_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_more_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_custom_content_active',
			'label'             => esc_html__( 'Check to Open Button Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_display_promo_head_title',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_promo_head_post_page_category_product_content_active',
			'label'             => esc_html__( 'Display title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_promo_head_show',
			'default'           => 'full-content',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_promo_head_post_page_category_product_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_promo_head',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_promo_head_video_link',
            'sanitize_callback' => 'esc_url_raw',
            'active_callback'   => 'wen_travel_is_promo_head_active',
            'label'             => esc_html__( 'Video Url', 'wen-travel-pro' ),
            'description'       => esc_html__( 'Provide a vilid Video URL like a Youtube Video Link', 'wen-travel-pro' ),
            'section'           => 'wen_travel_promo_head',
		)
	);
}
add_action( 'customize_register', 'wen_travel_promo_head' );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_promo_head_active' ) ) :
	/**
	* Return true if promotion headline is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_promo_head_visibility' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_post_content_active' ) ) :
	/**
	* Return true if post content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_page_content_active' ) ) :
	/**
	* Return true if promotion headline page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_category_content_active' ) ) :
	/**
	* Return true if promotion headline category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_post_page_category_product_content_active' ) ) :
	/**
	* Return true if promotion headline post/page/category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_post_page_category_product_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && ( 'page' === $type || 'post' === $type || 'category' === $type || 'product' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_custom_content_active' ) ) :
	/**
	* Return true if promotion headline custom content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_custom_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && ( 'custom' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_promo_head_product_content_active' ) ) :
	/**
	* Return true if promotion headline product content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_promo_head_product_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_promo_head_type' )->value();

		return ( wen_travel_is_promo_head_active( $control ) && ( 'product' === $type ) );
	}
endif;
