<?php
/**
 * Services options
 *
 * @package WEN_Travel
 */

/**
 * Add service content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_service_options( $wp_customize ) {
	// Add note to Jetpack Testimonial Section
    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_service_jetpack_note',
            'sanitize_callback' => 'sanitize_text_field',
            'custom_control'    => 'Wen_Travel_Note_Control',
            'label'             => sprintf( esc_html__( 'For all Services Options, go %1$shere%2$s', 'wen-travel-pro' ),
                '<a href="javascript:wp.customize.section( \'wen_travel_service\' ).focus();">',
                 '</a>'
            ),
           'section'            => 'service',
            'type'              => 'description',
            'priority'          => 1,
        )
    );

    $wp_customize->add_section( 'wen_travel_service', array(
			'title' => esc_html__( 'Services', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_layout',
			'default'           => 'layout-three',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_service_active',
			'choices'           => wen_travel_sections_layout_options(),
			'label'             => esc_html__( 'Select Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_service_inactive',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_service_inactive',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'textarea',
		)
	);

	$type = wen_travel_section_type_options();

	$type['ect-service'] = esc_html__( 'Custom Post Type', 'wen-travel-pro' );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_service_active',
			'description'       => sprintf( esc_html__( 'For Custom Post Type Content, install %1$sEssential Content Types%2$s Plugin with Services Type Enabled', 'wen-travel-pro' ),
                '<a target="_blank" href="https://wordpress.org/plugins/essential-content-types/">',
                '</a>'
            ),
            'choices'           => $type,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_service_cpt_note',
            'sanitize_callback' => 'sanitize_text_field',
            'custom_control'    => 'Wen_Travel_Note_Control',
            'active_callback'   => 'wen_travel_is_service_cpt_content_active',
            /* translators: 1: <a>/link tag start, 2: </a>/link tag close. */
			'label'             => sprintf( esc_html__( 'For CPT heading and sub-heading, go %1$shere%2$s', 'wen-travel-pro' ),
                 '<a href="javascript:wp.customize.control( \'ect_service_title\' ).focus();">',
                 '</a>'
            ),
            'section'           => 'wen_travel_service',
            'type'              => 'description',
        )
    );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_number',
			'default'           => 6,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_service_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Services is changed (Max no of Services is 20)', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'No of items', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'number',
			'transport'         => 'postMessage',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_text_alignment',
			'default'           => 'text-align-center',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_service_active',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_service_post_page_category_cpt_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_meta_show',
			'default'           => 'hide-meta',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_service_post_page_category_cpt_content_active',
			'choices'           => wen_travel_meta_show(),
			'label'             => esc_html__( 'Display Meta', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'select',
		)
	);


	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_service_category_content_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_service_select_category',
			'section'           => 'wen_travel_service',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_service_number', 6 );

	//loop for service post content
	for ( $i = 1; $i <= $number ; $i++ ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'default'           => 0,
				'active_callback'   => 'wen_travel_is_service_post_content_active',
				'input_attrs'       => array(
					'style'             => 'width: 40px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_service',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select'
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_service_page_content_active',
				'label'             => esc_html__( 'Services Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_service',
				'type'              => 'dropdown-pages',
				'allow_addition'    => true,
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_cpt_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_service_cpt_content_active',
				'label'             => esc_html__( 'Services', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_service',
				'type'              => 'select',
                'choices'           => wen_travel_generate_post_array( 'ect-service' ),
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Services #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_service',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_title_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_service_more_button_text_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_service_custom_service_active',
				'label'             => esc_html__( 'More Button Text', 'wen-travel-pro' ),
				'section'           => 'wen_travel_service',
				'type'              => 'text',
			)
		);
	} // End for().

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_service_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_service_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_service_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_service_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_service',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_service_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_service_active' ) ) :
	/**
	* Return true if service content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_service_option' )->value();

		//return true only if previewed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_cpt_service_inactive' ) ) :
	/**
	* Return true if cpt service is inactive
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_cpt_service_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		return ( wen_travel_is_service_active( $control ) && 'ect-service' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_post_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_page_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'page' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_cpt_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'ect-service' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_post_page_category_cpt_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_post_page_category_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'category' === $type || 'ect-service' === $type || 'page' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_service_custom_service_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_service_custom_service_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_service_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_service_active( $control ) && ( 'custom' === $type ) );
	}
endif;
