<?php
/**
 * Special Offer Options
 *
 * @package WEN_Travel
 */

/**
 * Add Special Offer options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_special_offer_options( $wp_customize ) {
	$wp_customize->add_section( 'wen_travel_special_offer_options', array(
			'title' => esc_html__( 'Special Offer', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_visibility',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'select',
		)
	);

	$types = wen_travel_section_type_options();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_type',
			'default'           => 'page',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'choices'           => $types,
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer',
			'default'           => '0',
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_special_offer_page_content_active',
			'label'             => esc_html__( 'Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'dropdown-pages',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_post',
			'default'           => 0,
			'sanitize_callback' => 'wen_travel_sanitize_post',
			'active_callback'   => 'wen_travel_is_special_offer_post_content_active',
			'label'             => esc_html__( 'Post', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'choices'           => wen_travel_generate_post_array(),
			'type'              => 'select',
		)
	);

	// create an empty array.
	$cats = array();

	$cats['0'] = esc_html__( '-- Select --', 'wen-travel-pro' );

	// we loop over the categories and set the names and
	// labels we need.
	foreach ( get_categories() as $categories => $category ) {
		$cats[ $category->term_id ] = $category->name;
	}

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_category',
			'default'           => '0',
			'sanitize_callback' => 'absint',
			'active_callback'   => 'wen_travel_is_special_offer_category_content_active',
			'label'             => esc_html__( 'Category', 'wen-travel-pro' ),
			'type'              => 'select',
			'choices'           => $cats,
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_percentage',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'label'             => esc_html__( 'Offer Number (Percent)', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'number',
			'input_attrs'       => array(
				'style' => 'width: 60px;',
				'min'   => 0,
				'max'   => 100,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_text',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'label'             => esc_html__( 'Offer Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_text_bg_image',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'custom_control'    => 'WP_Customize_Image_Control',
			'label'             => esc_html__( 'Offer Text Background Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_content',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'custom_control'    => 'WP_Customize_Image_Control',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Image Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_display_special_offer_title',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_special_offer_post_page_category_content_active',
			'label'             => esc_html__( 'Display Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_special_offer_post_page_category_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_img_align',
			'default'           => 'content-align-left',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'choices'           => array(
				'content-align-right' => esc_html__( 'Right', 'wen-travel-pro' ),
				'content-align-left'  => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Content Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_txt_align',
			'default'           => 'text-align-left',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_special_offer_active',
			'choices'           => array(
				'text-align-center' => esc_html__( 'Center', 'wen-travel-pro' ),
				'text-align-right'  => esc_html__( 'Right', 'wen-travel-pro' ),
				'text-align-left'   => esc_html__( 'Left', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Text Alignment', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'type'              => 'radio',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_more_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_more_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_special_offer_more_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_special_offer_custom_content_active',
			'label'             => esc_html__( 'Check to Open Button Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_special_offer_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_special_offer_options' );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_special_offer_active' ) ) :
	/**
	* Return true if Special Offer content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_special_offer_visibility' )->value();

		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_special_offer_post_content_active' ) ) :
	/**
	* Return true if post content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_special_offer_type' )->value();

		return ( wen_travel_is_special_offer_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_special_offer_page_content_active' ) ) :
	/**
	* Return true if Special Offer page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_special_offer_type' )->value();

		return ( wen_travel_is_special_offer_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_special_offer_category_content_active' ) ) :
	/**
	* Return true if Special Offer category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_special_offer_type' )->value();

		return ( wen_travel_is_special_offer_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_special_offer_post_page_category_content_active' ) ) :
	/**
	* Return true if Special Offer post/page/category content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_post_page_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_special_offer_type' )->value();

		return ( wen_travel_is_special_offer_active( $control ) && ( 'page' === $type || 'post' === $type || 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_special_offer_custom_content_active' ) ) :
	/**
	* Return true if Special Offer custom content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_special_offer_custom_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_special_offer_type' )->value();

		return ( wen_travel_is_special_offer_active( $control ) && 'custom' === $type );
	}
endif;
