<?php
/**
 * Stats options
 *
 * @package WEN_Travel
 */

/**
 * Add stats content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_stats_options( $wp_customize ) {

    $wp_customize->add_section( 'wen_travel_stats', array(
			'title' => esc_html__( 'Stats', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_bg_image',
			'sanitize_callback' => 'wen_travel_sanitize_image',
			'active_callback'   => 'wen_travel_is_stats_active',
			'custom_control'    => 'WP_Customize_Image_Control',
			'label'             => esc_html__( 'PNG Background Image for Posts', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_layout',
			'default'           => 'layout-four',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_stats_active',
			'choices'           => wen_travel_sections_layout_options(),
			'label'             => esc_html__( 'Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_stats_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_stats_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_stats_active',
            'choices'           => wen_travel_section_type_options(),
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'select',
		)
	);

    wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_number',
			'default'           => 4,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_stats_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Items is changed', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'No of Items', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'number',
			'transport'         => 'postMessage',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_stats_post_page_category_cpt_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_stats_category_content_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_stats_select_category',
			'section'           => 'wen_travel_stats',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_stats_number', 4 );

	//loop for stats post content
	for ( $i = 1; $i <= $number ; $i++ ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'default'           => 0,
				'active_callback'   => 'wen_travel_is_stats_post_content_active',
				'input_attrs'       => array(
					'style'             => 'width: 40px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_stats',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select'
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_stats_page_content_active',
				'label'             => esc_html__( 'Stats Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_stats',
				'type'              => 'dropdown-pages',
			)
		);


		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Stats #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_stats',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_title_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_stats_more_button_text_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_stats_image_content_active',
				'label'             => esc_html__( 'More Button Text', 'wen-travel-pro' ),
				'section'           => 'wen_travel_stats',
				'type'              => 'text',
			)
		);
	} // End for().

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_stats_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_stats_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_stats_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_stats_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_stats',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_stats_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_stats_active' ) ) :
	/**
	* Return true if stats content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_stats_option' )->value();

		//return true only if previewed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_cpt_stats_inactive' ) ) :
	/**
	* Return true if CPT stats content is inactive
	*
	* @since Wen Travel Pro 1.0
	*/

	function wen_travel_is_cpt_stats_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		return ( wen_travel_is_stats_active( $control ) && 'ect-service' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_post_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_page_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'page' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_cpt_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'ect-service' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_post_page_category_cpt_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_post_page_category_cpt_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'category' === $type || 'page' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_stats_image_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_stats_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_stats_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_stats_active( $control ) && ( 'custom' === $type ) );
	}
endif;
