<?php
/**
 * Team options
 *
 * @package WEN_Travel
 */

/**
 * Add team content options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_team_options( $wp_customize ) {

	$wp_customize->add_section( 'wen_travel_team', array(
			'title' => esc_html__( 'Team', 'wen-travel-pro' ),
			'panel' => 'wen_travel_theme_options',
		)
	);

	// Add color scheme setting and control.
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_layout',
			'default'           => 'layout-three',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_team_active',
			'choices'           => wen_travel_sections_layout_options(),
			'label'             => esc_html__( 'Select Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_team_active',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_team_active',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_team_active',
			'choices'           => wen_travel_section_type_options(),
			'label'             => esc_html__( 'Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_number',
			'default'           => 3,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_team_active',
			'description'       => esc_html__( 'Save and refresh the page if No. of Items is changed', 'wen-travel-pro' ),
			'input_attrs'       => array(
				'style' => 'width: 100px;',
				'min'   => 0,
			),
			'label'             => esc_html__( 'No of Items', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'number',
			'transport'         => 'postMessage',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_show',
			'default'           => 'hide-content',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_team_post_page_category_content_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_meta_show',
			'default'           => 'hide-meta',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_team_post_page_category_content_active',
			'choices'           => wen_travel_meta_show(),
			'label'             => esc_html__( 'Display Meta', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'select',
		)
	);


	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_team_category_content_active',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_team_select_category',
			'section'           => 'wen_travel_team',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_team_number', 3 );

	//loop for team post content
	for ( $i = 1; $i <= $number ; $i++ ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'default'           => 0,
				'active_callback'   => 'wen_travel_is_team_post_content_active',
				'input_attrs'       => array(
					'style'             => 'width: 40px;'
				),
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) . $i ,
				'section'           => 'wen_travel_team',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select'
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_team_page_content_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) . $i ,
				'section'           => 'wen_travel_team',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_team',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_image_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'custom_control'    => 'WP_Customize_Image_Control',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_title_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_position_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Position', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_content_' . $i,
				'sanitize_callback' => 'wp_kses_post',
				'active_callback'   => 'wen_travel_is_team_image_content_active',
				'label'             => esc_html__( 'Content', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_social_link_one_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_team_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) .  $i . esc_html__( ': Social Link #1', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_social_link_two_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_team_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) .  $i . esc_html__( ': Social Link #2', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_social_link_three_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_team_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) .  $i . esc_html__( ': Social Link #3', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_team_social_link_four_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_team_active',
				'label'             => esc_html__( 'Team #', 'wen-travel-pro' ) .  $i . esc_html__( ': Social Link #4', 'wen-travel-pro' ),
				'section'           => 'wen_travel_team',
			)
		);
	} // End for().

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_text',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'wen_travel_is_team_active',
			'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_link',
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'   => 'wen_travel_is_team_active',
			'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_team_target',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_team_active',
			'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
			'section'           => 'wen_travel_team',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
}
add_action( 'customize_register', 'wen_travel_team_options', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_team_active' ) ) :
	/**
	* Return true if team content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_team_option' )->value();

		//return true only if previewed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_team_post_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_post_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_team_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_team_active( $control ) && ( 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_team_page_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_page_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_team_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_team_active( $control ) && ( 'page' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_team_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_team_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_team_active( $control ) && ( 'category' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_team_post_page_category_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_post_page_category_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_team_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_team_active( $control ) && ( 'category' === $type || 'page' === $type || 'post' === $type ) );
	}
endif;

if ( ! function_exists( 'wen_travel_is_team_image_content_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since WEN Travel Pro 1.0
	*/
	function wen_travel_is_team_image_content_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_team_type' )->value();

		//return true only if previewed page on customizer matches the type of content option selected and is or is not selected type
		return ( wen_travel_is_team_active( $control ) && ( 'custom' === $type ) );
	}
endif;
