<?php
/**
 * Add Testimonial Settings in Customizer
 *
 * @package WEN_Travel
*/

/**
 * Add testimonial options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_testimonial_options( $wp_customize ) {
	// Add note to Jetpack Testimonial Section
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_jetpack_testimonial_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'label'             => sprintf( esc_html__( 'For Testimonial Options for Wen Travel Pro Theme, go %1$shere%2$s', 'wen-travel-pro' ),
				'<a href="javascript:wp.customize.section( \'wen_travel_testimonials\' ).focus();">',
				 '</a>'
			),
		   'section'            => 'jetpack_testimonials',
			'type'              => 'description',
			'priority'          => 1,
		)
	);

	$wp_customize->add_section( 'wen_travel_testimonials', array(
			'panel'    => 'wen_travel_theme_options',
			'title'    => esc_html__( 'Testimonials', 'wen-travel-pro' ),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_option',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'select',
			'priority'          => 1,
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_transition_in',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'choices'           => wen_travel_transition_effects(),
			'label'             => esc_html__( 'Transition In', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_transition_out',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'choices'           => wen_travel_transition_effects(),
			'label'             => esc_html__( 'Transition Out', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_nav',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Display nav arrows', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_dots',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Display nav dots', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_autoplay',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Autoplay', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_loop',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Loop (Last to first)', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_transition_timeout',
			'default'           => 4,
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'input_attrs'       => array(
				'style'       => 'width: 100px;',
				'min'         => 0,
			),
			'label'             => esc_html__( 'Transition timeout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'number',
		)
	);

	$type = wen_travel_section_type_options();

	$type['jetpack-testimonial'] = esc_html__( 'Custom Post Type', 'wen-travel-pro' );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_type',
			'default'           => 'category',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'choices'           => $type,
			'description'       => sprintf( esc_html__( 'For Custom Post Type Content, install %1$sEssential Content Types%2$s Plugin with Testimonial Content Type Enabled', 'wen-travel-pro' ),
				'<a target="_blank" href="https://wordpress.org/plugins/essential-content-types/">',
				'</a>'
			),
			'label'             => esc_html__( 'Select Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_cpt_note',
			'sanitize_callback' => 'sanitize_text_field',
			'custom_control'    => 'Wen_Travel_Note_Control',
			'active_callback'   => 'wen_travel_is_jetpack_testimonial_active',
			/* translators: 1: <a>/link tag start, 2: </a>/link tag close. */
			'label'             => sprintf( esc_html__( 'For CPT heading and sub-heading, go %1$shere%2$s', 'wen-travel-pro' ),
				'<a href="javascript:wp.customize.section( \'jetpack_testimonials\' ).focus();">',
				'</a>'
			),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'description',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_title',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_testimonial_inactive',
			'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'text',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_description',
			'sanitize_callback' => 'wp_kses_post',
			'active_callback'   => 'wen_travel_is_cpt_testimonial_inactive',
			'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_number',
			'default'           => '3',
			'sanitize_callback' => 'wen_travel_sanitize_number_range',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Number of items', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'number',
			'input_attrs'       => array(
				'style'             => 'width: 100px;',
				'min'               => 0,
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_enable_title',
			'default'           => 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'active_callback'   => 'wen_travel_is_testimonial_active',
			'label'             => esc_html__( 'Display Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_show',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'active_callback'   => 'wen_travel_is_post_page_category_cpt_testimonial_active',
			'choices'           => wen_travel_content_show(),
			'label'             => esc_html__( 'Display Content', 'wen-travel-pro' ),
			'section'           => 'wen_travel_testimonials',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_testimonial_select_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'active_callback'   => 'wen_travel_is_category_testimonial_active',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'label'             => esc_html__( 'Select Categories', 'wen-travel-pro' ),
			'name'              => 'wen_travel_testimonial_select_category',
			'section'           => 'wen_travel_testimonials',
			'type'              => 'dropdown-categories',
		)
	);

	$number = get_theme_mod( 'wen_travel_testimonial_number', 3 );

	for ( $i = 1; $i <= $number ; $i++ ) {
		//for featured post content
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_post_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_post_testimonial_active',
				'input_attrs'       => array(
				'style'             => 'width: 100px;'
				),
				'label'             => esc_html__( 'Post', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_testimonials',
				'choices'           => wen_travel_generate_post_array(),
				'type'              => 'select',
			)
		);

		//for CPT
		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_cpt_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_jetpack_testimonial_active',
				'label'             => esc_html__( 'Testimonial', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_testimonials',
				'type'              => 'select',
				'choices'           => wen_travel_generate_post_array( 'jetpack-testimonial' ),
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_page_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_post',
				'active_callback'   => 'wen_travel_is_page_testimonial_active',
				'label'             => esc_html__( 'Page', 'wen-travel-pro' ) . ' ' . $i ,
				'section'           => 'wen_travel_testimonials',
				'type'              => 'dropdown-pages',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_note_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'custom_control'    => 'Wen_Travel_Note_Control',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Testimonial #', 'wen-travel-pro' ) .  $i,
				'section'           => 'wen_travel_testimonials',
				'type'              => 'description',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_image_' . $i,
				'custom_control'      => 'WP_Customize_Image_Control',
				'sanitize_callback' => 'wen_travel_sanitize_image',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Image', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_link_' . $i,
				'sanitize_callback' => 'esc_url_raw',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Link', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_target_' . $i,
				'sanitize_callback' => 'wen_travel_sanitize_checkbox',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
				'custom_control'    => 'Wen_Travel_Toggle_Control',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_content_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Testimonial Text', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
				'type'              => 'textarea',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_title_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Name', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
				'type'              => 'text',
			)
		);

		wen_travel_register_option( $wp_customize, array(
				'name'              => 'wen_travel_testimonial_position_' . $i,
				'sanitize_callback' => 'sanitize_text_field',
				'active_callback'   => 'wen_travel_is_image_testimonial_active',
				'label'             => esc_html__( 'Position', 'wen-travel-pro' ),
				'section'           => 'wen_travel_testimonials',
				'type'              => 'text',
			)
		);
	} // End for().
}
add_action( 'customize_register', 'wen_travel_testimonial_options' );

/**
 * Active Callback Functions
 */
if ( ! function_exists( 'wen_travel_is_testimonial_active' ) ) :
	/**
	* Return true if testimonial is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_testimonial_active( $control ) {
		$enable = $control->manager->get_setting( 'wen_travel_testimonial_option' )->value();

		//return true only if previwed page on customizer matches the type of content option selected
		return wen_travel_check_section( $enable );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_testimonial_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'post' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_jetpack_testimonial_active' ) ) :
	/**
	* Return true if jetpack testimonial is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_jetpack_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'jetpack-testimonial' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_page_testimonial_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_page_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'page' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_category_testimonial_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_category_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'category' === $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_post_page_category_cpt_testimonial_active' ) ) :
	/**
	* Return true if custom option is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_post_page_category_cpt_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'custom' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_cpt_testimonial_inactive' ) ) :
	/**
	* Return true if cpt option is not active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_cpt_testimonial_inactive( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'jetpack-testimonial' !== $type );
	}
endif;

if ( ! function_exists( 'wen_travel_is_image_testimonial_active' ) ) :
	/**
	* Return true if page content is active
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_image_testimonial_active( $control ) {
		$type = $control->manager->get_setting( 'wen_travel_testimonial_type' )->value();

		//return true only if previwed page on customizer matches the type of option selected
		return ( wen_travel_is_testimonial_active( $control ) && 'custom' === $type );
	}
endif;
