<?php
/**
 * Theme Options
 *
 * @package WEN_Travel
 */

/**
 * Add theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_theme_options( $wp_customize ) {
	$wp_customize->add_panel( 'wen_travel_theme_options', array(
		'title'    => esc_html__( 'Theme Options', 'wen-travel-pro' ),
		'priority' => 130,
	) );

	// Font Family Options.
	$wp_customize->add_section( 'wen_travel_font_family', array(
		'panel' => 'wen_travel_theme_options',
		'title' => esc_html__( 'Font Family Options', 'wen-travel-pro' ),
	) );

	$load_font_cdn_desc = sprintf(
		wp_kses(
			__( 'A German court fined a website using Google-hosted webfonts for violating Europe’s General Data Protection Regulation (GDPR). So this has been discouraged. More info %1$shere%2$s', 'wen-travel-pro' ),
			array(
				'a' => array(
					'href' => array(),
					'target' => array(),
				)
			)
		),
		'<a target="_blank" href="https://make.wordpress.org/themes/2022/06/18/complying-with-gdpr-when-using-google-fonts/">',
		'</a>'
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'load_font_cdn',
			'default'           => 0,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'description'       => $load_font_cdn_desc,
			'label'             => esc_html__( 'Load Google Font from CDN', 'wen-travel-pro' ),
			'section'           => 'wen_travel_font_family',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );

	$avaliable_fonts = wen_travel_avaliable_fonts();

	$choices = array();

	foreach ( $avaliable_fonts as $font ) {
		$choices[ $font['value'] ] = str_replace( '"', '', $font['label'] );
	}

	$font_family_options = wen_travel_font_family_options();

	foreach ( $font_family_options as $key => $value ) {
		wen_travel_register_option( $wp_customize, array(
				'name'              => $key,
				'default'           => $value['default'],
				'sanitize_callback' => 'wen_travel_sanitize_select',
				'choices'           => $choices,
				'label'             => $value['label'],
				'section'           => 'wen_travel_font_family',
				'type'              => 'select',
			)
		);
	}

	// Footer Options.
	$wp_customize->add_section( 'wen_travel_footer_options', array(
		'title'       => esc_html__( 'Footer Options', 'wen-travel-pro' ),
		'description' => esc_html__( 'You can either add html or plain text or custom shortcodes, which will be automatically inserted into your theme. Some shorcodes: [the-year], [site-link] and [privacy-policy-link] for current year, site link and privacy policy link respectively.', 'wen-travel-pro' ),
		'panel'       => 'wen_travel_theme_options',
	) );

	$theme_data = wp_get_theme();

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_footer_copyright_text',
			'default'           => sprintf( _x( 'Copyright &copy; %1$s %2$s %3$s', '1: Year, 2: Site Title with home URL, 3: Privacy Policy Link', 'wen-travel-pro' ), '[the-year]', '[site-link]', '[privacy-policy-link]' ) . '<span class="sep"> | </span>',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Copyright Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_footer_options',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_footer_powered_by',
			'default'           => esc_html( $theme_data->get( 'Name' ) ) . '&nbsp;' . esc_html__( 'by', 'wen-travel-pro' ) . '&nbsp;<a target="_blank" href="' . esc_url( $theme_data->get( 'AuthorURI' ) ) . '">' . esc_html( $theme_data->get( 'Author' ) ) . '</a>',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Powered By Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_footer_options',
			'type'              => 'textarea',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_latest_posts_title',
			'default'           => esc_html__( 'News', 'wen-travel-pro' ),
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Latest Posts Title', 'wen-travel-pro' ),
			'section'           => 'wen_travel_theme_options',
		)
	);

	// Layout Options
	$wp_customize->add_section( 'wen_travel_layout_options', array(
		'title' => esc_html__( 'Layout Options', 'wen-travel-pro' ),
		'panel' => 'wen_travel_theme_options',
		)
	);

	/* Layout Type */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_layout_type',
			'default'           => 'fluid',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Site Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_layout_options',
			'type'              => 'radio',
			'choices'           => array(
				'fluid' => esc_html__( 'Fluid', 'wen-travel-pro' ),
				'boxed' => esc_html__( 'Boxed', 'wen-travel-pro' ),
			),
		)
	);

	/* Default Layout */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_default_layout',
			'default'           => 'right-sidebar',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Default Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_layout_options',
			'type'              => 'radio',
			'choices'           => array(
				'right-sidebar'         => esc_html__( 'Right Sidebar ( Content, Primary Sidebar )', 'wen-travel-pro' ),
				'left-sidebar'          => esc_html__( 'Left Sidebar ( Primary Sidebar, Content )', 'wen-travel-pro' ),
				'no-sidebar'            => esc_html__( 'No Sidebar', 'wen-travel-pro' ),
				'no-sidebar-full-width' => esc_html__( 'No Sidebar: Full Width', 'wen-travel-pro' ),
			),
		)
	);

	/* Header Options */
	$wp_customize->add_section( 'wen_travel_header_options', array(
		'title' => esc_html__( 'Header Options', 'wen-travel-pro' ),
		'panel' => 'wen_travel_theme_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_style',
			'default'           => 'style-one',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => array(
				'style-one' => esc_html__( 'Style One', 'wen-travel-pro' ),
				'style-two' => esc_html__( 'Style Two', 'wen-travel-pro' ),
			),
			'label'             => esc_html__( 'Style', 'wen-travel-pro' ),
			'section'           => 'wen_travel_header_options',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_transparent_header',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'default'           => 1,
			'description'       => esc_html__( 'Header Media or Featured Slider needs to be turned on for transparent header to take effect.', 'wen-travel-pro' ),
			'label'             => esc_html__( 'Transparent Header', 'wen-travel-pro' ),
			'section'           => 'wen_travel_header_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );

	/* Homepage/Archive Layout */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_homepage_archive_layout',
			'default'           => 'no-sidebar-full-width',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Homepage/Archive Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_layout_options',
			'type'              => 'radio',
			'choices'           => array(
				'right-sidebar'         => esc_html__( 'Right Sidebar ( Content, Primary Sidebar )', 'wen-travel-pro' ),
				'left-sidebar'          => esc_html__( 'Left Sidebar ( Primary Sidebar, Content )', 'wen-travel-pro' ),
				'no-sidebar'            => esc_html__( 'No Sidebar', 'wen-travel-pro' ),
				'no-sidebar-full-width' => esc_html__( 'No Sidebar: Full Width', 'wen-travel-pro' ),
			),
		)
	);

	/* Archive Content Layout */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_content_layout',
			'default'           => 'excerpt',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Archive Content Layout', 'wen-travel-pro' ),
			'section'           => 'wen_travel_layout_options',
			'type'              => 'radio',
			'choices'           => array(
				'excerpt'            => esc_html__( 'Excerpt with Featured Image', 'wen-travel-pro' ),
				'full-content-custom' => esc_html__( 'Show Full Content With Image', 'wen-travel-pro' ),
				'full-content'       => esc_html__( 'Show Full Content ( No Featured Image )', 'wen-travel-pro' ),
			),
		)
	);

	wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_single_page_title',
            'default'			 => 1,
            'sanitize_callback'  => 'wen_travel_sanitize_checkbox',
            'label'              => esc_html__( 'Single Page title', 'wen-travel-pro' ),
            'section'            => 'wen_travel_layout_options',
            'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );

	/* Single Page/Post Image */
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_single_layout',
			'default'           => 'disabled',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Single Page/Post Image', 'wen-travel-pro' ),
			'section'           => 'wen_travel_layout_options',
			'type'              => 'radio',
			'choices'           => array(
				'disabled'              => esc_html__( 'Disabled', 'wen-travel-pro' ),
				'post-thumbnail'        => esc_html__( 'Post Thumbnail', 'wen-travel-pro' ),
				'wen-travel-slider' => esc_html__( 'Slider Image Size (1920x1080)', 'wen-travel-pro' ),
				'full'                  => esc_html__( 'Original Image Size', 'wen-travel-pro' ),
			),
		)
	);

	// Excerpt Options.
	$wp_customize->add_section( 'wen_travel_excerpt_options', array(
		'panel'     => 'wen_travel_theme_options',
		'title'     => esc_html__( 'Excerpt Options', 'wen-travel-pro' ),
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_excerpt_length',
			'default'           => '20',
			'sanitize_callback' => 'absint',
			'input_attrs' => array(
				'min'   => 10,
				'max'   => 200,
				'step'  => 5,
				'style' => 'width: 60px;',
			),
			'label'    => esc_html__( 'Excerpt Length (words)', 'wen-travel-pro' ),
			'section'  => 'wen_travel_excerpt_options',
			'type'     => 'number',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_excerpt_more_text',
			'default'           => esc_html__( 'Continue reading...', 'wen-travel-pro' ),
			'sanitize_callback' => 'sanitize_text_field',
			'label'             => esc_html__( 'Read More Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_excerpt_options',
			'type'              => 'text',
		)
	);

	// Excerpt Options.
	$wp_customize->add_section( 'wen_travel_search_options', array(
		'panel'     => 'wen_travel_theme_options',
		'title'     => esc_html__( 'Search Options', 'wen-travel-pro' ),
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_search_text',
			'default'           => esc_html__( 'Search', 'wen-travel-pro' ),
			'sanitize_callback' => 'sanitize_text_field',
			'label'             => esc_html__( 'Search Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_search_options',
			'type'              => 'text',
		)
	);

	// Comment Option.
	$wp_customize->add_section( 'wen_travel_comment_option', array(
		'description'   => esc_html__( 'Comments can also be disabled on a per post/page basis when creating/editing posts/pages.', 'wen-travel-pro' ),
		'panel'         => 'wen_travel_theme_options',
		'title'         => esc_html__( 'Comment Options', 'wen-travel-pro' ),
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_comment_option',
			'default'           => 'use-wordpress-setting',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => array(
				'use-wordpress-setting' => esc_html__( 'Use WordPress Setting', 'wen-travel-pro' ),
				'disable-in-pages'      => esc_html__( 'Disable in Pages', 'wen-travel-pro' ),
				'disable-completely'    => esc_html__( 'Disable Completely', 'wen-travel-pro' ),
			),
			'label'             => __( 'Comment Option', 'wen-travel-pro' ),
			'section'           => 'wen_travel_comment_option',
			'type'              => 'select',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_website_field',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'default'           => 1,
			'label'             => esc_html__( 'Display Website Field', 'wen-travel-pro' ),
			'section'           => 'wen_travel_comment_option',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	// Homepage / Frontpage Options.
	$wp_customize->add_section( 'wen_travel_homepage_options', array(
		'description' => esc_html__( 'Only posts that belong to the categories selected here will be displayed on the front page', 'wen-travel-pro' ),
		'panel'       => 'wen_travel_theme_options',
		'title'       => esc_html__( 'Homepage / Frontpage Options', 'wen-travel-pro' ),
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_display_homepage_posts',
			'default'			=> 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Recent Posts/Content on homepage', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);
	
	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_recent_posts_heading',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'News', 'wen-travel-pro' ),
			'label'             => esc_html__( 'Recent Posts Heading', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_static_page_heading',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'	=> 'wen_travel_is_static_page_enabled',
			'default'           => esc_html__( 'Archives', 'wen-travel-pro' ),
			'label'             => esc_html__( 'Posts Page Header Text', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_recent_posts_subheading',
			'sanitize_callback' => 'wp_kses_post',
			'label'             => esc_html__( 'Recent Posts Sub Heading', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
			'type'              => 'textarea'
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_front_page_category',
			'sanitize_callback' => 'wen_travel_sanitize_category_list',
			'custom_control'    => 'Wen_Travel_Multi_Cat',
			'active_callback'   => 'wen_travel_is_homepage_posts_enabled',
			'label'             => esc_html__( 'Categories', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
			'type'              => 'dropdown-categories',
		)
	);

	// Disable Recent post in static frontpage
    wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_enable_static_page_posts',
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Recent Posts on Static Page', 'wen-travel-pro' ),
			'section'           => 'wen_travel_homepage_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
	    )
	);

	//Menu Options
	$wp_customize->add_section( 'wen_travel_menu_options', array(
		'description' => esc_html__( 'Extra Menu Options specific to this theme', 'wen-travel-pro' ),
		'title'       => esc_html__( 'Menu Options', 'wen-travel-pro' ),
		'panel'       => 'wen_travel_theme_options',
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_primary_search_enable',
			'default'			=> 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Search in Primary Menu', 'wen-travel-pro' ),
			'section'           => 'wen_travel_menu_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_header_cart_enable',
			'default'			=> 0,
			'description'       => esc_html__( 'Enable WooCommerce Plugin for cart icon', 'wen-travel-pro' ),
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Cart Icon', 'wen-travel-pro' ),
			'section'           => 'wen_travel_menu_options',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_menu_type',
			'default'           => 'classic',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'label'             => esc_html__( 'Menu Type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_menu_options',
			'type'              => 'radio',
			'choices'           => array(
				'modern'  => esc_html__( 'Modern', 'wen-travel-pro' ),
				'classic' => esc_html__( 'Classic', 'wen-travel-pro' ),
	        ),
	    )
	);
	//Menu Options End

	// Pagination Options.
	$pagination_type = get_theme_mod( 'wen_travel_pagination_type', 'default' );

	$wp_customize->add_section( 'wen_travel_pagination_options', array(
		'panel'           => 'wen_travel_theme_options',
		'title'           => esc_html__( 'Pagination Options', 'wen-travel-pro' ),
		'active_callback' => 'wen_travel_scroll_plugins_inactive'
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_pagination_type',
			'default'           => 'default',
			'sanitize_callback' => 'wen_travel_sanitize_select',
			'choices'           => wen_travel_get_pagination_types(),
			'label'             => esc_html__( 'Pagination type', 'wen-travel-pro' ),
			'section'           => 'wen_travel_pagination_options',
			'type'              => 'select',
		)
	);

	// For WooCommerce layout: wen_travel_woocommerce_layout, check woocommerce-options.php.
	/* Scrollup Options */
	$wp_customize->add_section( 'wen_travel_scrollup', array(
		'panel'    => 'wen_travel_theme_options',
		'title'    => esc_html__( 'Scrollup Options', 'wen-travel-pro' ),
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_disable_scrollup',
			'default'			=> 1,
			'sanitize_callback' => 'wen_travel_sanitize_checkbox',
			'label'             => esc_html__( 'Scroll Up', 'wen-travel-pro' ),
			'section'           => 'wen_travel_scrollup',
			'custom_control'    => 'Wen_Travel_Toggle_Control',
		)
	);

	// Sort Section.
	$wp_customize->add_section( 'wen_travel_sections_sort', array(
		'title'       => esc_html__( 'Sections Sorter', 'wen-travel-pro' ),
		'description' => esc_html__( 'Drag and drop to sort your sections', 'wen-travel-pro' ),
		'panel'       => 'wen_travel_theme_options',
	) );

	wen_travel_register_option( $wp_customize, array(
			'name'              => 'wen_travel_sections_sort',
			'default'           => wen_travel_get_default_sections_value(),
			'label'             => esc_html__( 'Sortable Sections', 'wen-travel-pro' ),
			'custom_control'    => 'Wen_Travel_Sortable_Custom_Control',
			'sanitize_callback' => 'sanitize_text_field',
			'section'           => 'wen_travel_sections_sort',
			'type'              => 'custom-sortable',
		)
	);
}
add_action( 'customize_register', 'wen_travel_theme_options' );


/**
 * Returns an array of avaliable fonts registered for Wen Travel Pro
 *
 * @since Wen Travel Pro 1.0
 */
function wen_travel_avaliable_fonts() {
	$avaliable_fonts = array(
		'arial-black' => array(
			'value' => 'arial-black',
			'label' => '"Arial Black", Gadget, sans-serif',
		),
		'allan' => array(
			'value' => 'allan',
			'label' => '"Allan", sans-serif',
		),
		'allerta' => array(
			'value' => 'allerta',
			'label' => '"Allerta", sans-serif',
		),
		'alegreya' => array(
			'value' => 'alegreya',
			'label' => '"Alegreya Sans", sans-serif',
		),
		'amaranth' => array(
			'value' => 'amaranth',
			'label' => '"Amaranth", sans-serif',
		),
		'amatic-sc' => array(
			'value' => 'amatic-sc',
			'label' => '"Amatic SC", cursive',
		),
		'arial' => array(
			'value' => 'arial',
			'label' => 'Arial, Helvetica, sans-serif',
		),
		'bitter' => array(
			'value' => 'bitter',
			'label' => '"Bitter", sans-serif',
		),
		'cabin' => array(
			'value' => 'cabin',
			'label' => '"Cabin", sans-serif',
		),
		'cantarell' => array(
			'value' => 'cantarell',
			'label' => '"Cantarell", sans-serif',
		),
		'century-gothic' => array(
			'value' => 'century-gothic',
			'label' => '"Century Gothic", sans-serif',
		),
		'courier-new' => array(
			'value' => 'courier-new',
			'label' => '"Courier New", Courier, monospace',
		),
		'crimson-text' => array(
			'value' => 'crimson-text',
			'label' => '"Crimson Text", sans-serif',
		),
		'cuprum' => array(
			'value' => 'cuprum',
			'label' => '"Cuprum", sans-serif',
		),
		'dancing-script' => array(
			'value' => 'dancing-script',
			'label' => '"Dancing Script", sans-serif',
		),
		'droid-sans' => array(
			'value' => 'droid-sans',
			'label' => '"Droid Sans", sans-serif',
		),
		'droid-serif' => array(
			'value' => 'droid-serif',
			'label' => '"Droid Serif", sans-serif',
		),
		'exo' => array(
			'value' => 'exo',
			'label' => '"Exo", sans-serif',
		),
		'exo-2' => array(
			'value' => 'exo-2',
			'label' => '"Exo 2", sans-serif',
		),
		'georgia' => array(
			'value' => 'georgia',
			'label' => 'Georgia, "Times New Roman", Times, serif',
		),
		'helvetica' => array(
			'value' => 'helvetica',
			'label' => 'Helvetica, "Helvetica Neue", Arial, sans-serif',
		),
		'helvetica-neue' => array(
			'value' => 'helvetica-neue',
			'label' => '"Helvetica Neue",Helvetica,Arial,sans-serif',
		),
		'istok-web' => array(
			'value' => 'istok-web',
			'label' => '"Istok Web", sans-serif',
		),
		'impact' => array(
			'value' => 'impact',
			'label' => 'Impact, Charcoal, sans-serif',
		),
		'josefin-sans' => array(
			'value' => 'josefin-sans',
			'label' => '"Josefin Sans", sans-serif',
		),
		'lato' => array(
			'value' => 'lato',
			'label' => '"Lato", sans-serif',
		),
		'lucida-sans-unicode' => array(
			'value' => 'lucida-sans-unicode',
			'label' => '"Lucida Sans Unicode", "Lucida Grande", sans-serif',
		),
		'lucida-grande' => array(
			'value' => 'lucida-grande',
			'label' => '"Lucida Grande", "Lucida Sans Unicode", sans-serif',
		),
		'lobster' => array(
			'value' => 'lobster',
			'label' => '"Lobster", sans-serif',
		),
		'lora' => array(
			'value' => 'lora',
			'label' => '"Lora", serif',
		),
		'monaco' => array(
			'value' => 'monaco',
			'label' => 'Monaco, Consolas, "Lucida Console", monospace, sans-serif',
		),
		'muli' => array(
			'value' => 'muli',
			'label' => 'Muli, sans-serif',
		),
		'mrs-saint-delafield' => array(
			'value' => 'mrs-saint-delafield',
			'label' => '"Mrs Saint Delafield", cursive',
		),
		'montserrat' => array(
			'value' => 'montserrat',
			'label' => '"Montserrat", sans-serif',
		),
		'nobile' => array(
			'value' => 'nobile',
			'label' => '"Nobile", sans-serif',
		),
		'noto-serif' => array(
			'value' => 'noto-serif',
			'label' => '"Noto Serif", serif',
		),
		'neuton' => array(
			'value' => 'neuton',
			'label' => '"Neuton", serif',
		),
		'open-sans' => array(
			'value' => 'open-sans',
			'label' => '"Open Sans", sans-serif',
		),
		'oswald' => array(
			'value' => 'oswald',
			'label' => '"Oswald", sans-serif',
		),
		'palatino' => array(
			'value' => 'palatino',
			'label' => 'Palatino, "Palatino Linotype", "Book Antiqua", serif',
		),
		'patua-one' => array(
			'value' => 'patua-one',
			'label' => '"Patua One", sans-serif',
		),
		'poppins' => array(
			'value' => 'poppins',
			'label' => '"Poppins", sans-serif',
		),
		'playfair-display' => array(
			'value' => 'playfair-display',
			'label' => '"Playfair Display", sans-serif',
		),
		'pt-sans' => array(
			'value' => 'pt-sans',
			'label' => '"PT Sans", sans-serif',
		),
		'pt-serif' => array(
			'value' => 'pt-serif',
			'label' => '"PT Serif", serif',
		),
		'quattrocento-sans' => array(
			'value' => 'quattrocento-sans',
			'label' => '"Quattrocento Sans", sans-serif',
		),
		'roboto' => array(
			'value' => 'roboto',
			'label' => '"Roboto", sans-serif',
		),
		'roboto-slab' => array(
			'value' => 'roboto-slab',
			'label' => '"Roboto Slab", serif',
		),
		'rubik' => array(
			'value' => 'rubik',
			'label' => '"Rubik", serif',
		),
		'sans-serif' => array(
			'value' => 'sans-serif',
			'label' => 'Sans Serif, Arial',
		),
		'source-sans-pro' => array(
			'value' => 'source-sans-pro',
			'label' => '"Source Sans Pro", sans-serif',
		),
		'tahoma' => array(
			'value' => 'tahoma',
			'label' => 'Tahoma, Geneva, sans-serif',
		),
		'trebuchet-ms' => array(
			'value' => 'trebuchet-ms',
			'label' => '"Trebuchet MS", "Helvetica", sans-serif',
		),
		'times-new-roman' => array(
			'value' => 'times-new-roman',
			'label' => '"Times New Roman", Times, serif',
		),
		'ubuntu' => array(
			'value' => 'ubuntu',
			'label' => '"Ubuntu", sans-serif',
		),
		'varela' => array(
			'value' => 'varela',
			'label' => '"Varela", sans-serif',
		),
		'verdana' => array(
			'value' => 'verdana',
			'label' => 'Verdana, Geneva, sans-serif',
		),
		'yanone-kaffeesatz' => array(
			'value' => 'yanone-kaffeesatz',
			'label' => '"Yanone Kaffeesatz", sans-serif',
		),
	);

	return apply_filters( 'wen_travel_avaliable_fonts', $avaliable_fonts );
}


/**
 * Returns an array of font family options
 *
 * @since Wen Travel Pro 1.0
 */
function wen_travel_font_family_options() {
	$options = array(
		'wen_travel_body_font'         => array(
			'label'    => esc_html__( 'Default Font Family', 'wen-travel-pro' ),
			'default'  => 'open-sans',
			'selector' => 'body, input, select, textarea, .trip-filter-section .description-box button, .posts-navigation a, input[type="submit"].submit, .filter-button-group .button, button, .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .comment-meta .author-name, #content #infinite-handle span button, .ui-tabs .ui-tabs-nav li a, input[type="button"], input[type="reset"], input[type="submit"], input[type="submit"].wpcf7-submit',
		),
		'wen_travel_title_font'        => array(
			'label'    => esc_html__( 'Site Title Font Family', 'wen-travel-pro' ),
			'default'  => 'open-sans',
			'selector' => '.site-title',
		),
		'wen_travel_tagline_font'      => array(
			'label'    => esc_html__( 'Site Tagline Font Family', 'wen-travel-pro' ),
			'default'  => 'open-sans',
			'selector' => '.site-description',
		),
		'wen_travel_navigation_font'      => array(
			'label'    => esc_html__( 'Navigation Font Family', 'wen-travel-pro' ),
			'default'  => 'alegreya',
			'selector' => '.main-navigation .nav-menu li a, .menu-label',
		),
		'wen_travel_headings_font'     => array(
			'label'    => esc_html__( 'Headings Tags from h1 to h6 Font Family', 'wen-travel-pro' ),
			'default'  => 'open-sans',
			'selector' => 'h1, h2, h3, h4, h5, h6, #testimonial-content-section .entry-title, .widget-title, #stats-section .entry-title, .post-navigation .post-title, .team-content-wrapper .entry-title, .custom-header-content .section-title',
		),
		'wen_travel_section_title_font'     => array(
			'label'    => esc_html__( 'Section Title Font', 'wen-travel-pro' ),
			'default'  => 'lora',
			'selector' => '#feature-slider-section .entry-title, .home .custom-header-content .section-title, .section-title, .contact-content-wrapper .entry-title, .special-offer-content-wrapper .section-description .offer-percentage',
		),
	);

	return apply_filters( 'wen_travel_font_family_options', $options );
}

/** Active Callback Functions */

if ( ! function_exists( 'wen_travel_is_homepage_posts_enabled' ) ) :
	/**
	* Return true if hommepage posts/content is enabled
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_is_homepage_posts_enabled( $control ) {
		return ( $control->manager->get_setting( 'wen_travel_display_homepage_posts' )->value() ? true : false );
	}
endif;

if ( ! function_exists( 'wen_travel_scroll_plugins_inactive' ) ) :
	/**
	* Return true if infinite scroll functionality exists
	*
	* @since Wen Travel Pro 1.0
	*/
	function wen_travel_scroll_plugins_inactive( $control ) {
		if ( ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'infinite-scroll' ) ) ) {
			// Support infinite scroll plugins.
			return false;
		}

		return true;
	}
endif;

if ( ! function_exists( 'wen_travel_is_static_page_enabled' ) ) :
	/**
	* Return true if A Static Page is enabled
	*
	* @since Wen Travel Pro 1.1.2
	*/
	function wen_travel_is_static_page_enabled( $control ) {
		$enable = $control->manager->get_setting( 'show_on_front' )->value();
		if ( 'page' === $enable ) {
			return true;
		}
		return false;
	}
endif;
