<?php
/**
 * Adding support for WooCommerce Products Showcase Option
 */

/**
 * Add WooCommerce Product Showcase Options to customizer
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_travel_woo_products_showcase( $wp_customize ) {
   $wp_customize->add_section( 'wen_travel_woo_products_showcase', array(
        'title' => esc_html__( 'WooCommerce Products Showcase', 'wen-travel-pro' ),
        'panel' => 'wen_travel_theme_options',
    ) );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_option',
            'default'           => 'disabled',
            'sanitize_callback' => 'wen_travel_sanitize_select',
            'choices'           => wen_travel_section_visibility_options(),
            'label'             => esc_html__( 'Enable on', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'select',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_title',
            'sanitize_callback' => 'wp_kses_post',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Title', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'text',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_description',
            'sanitize_callback' => 'wp_kses_post',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Description', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'textarea',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_number',
            'default'           => 8,
            'sanitize_callback' => 'wen_travel_sanitize_number_range',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'description'       => esc_html__( 'Save and refresh the page if No. of Products is changed. Set -1 to display all', 'wen-travel-pro' ),
            'input_attrs'       => array(
                'style' => 'width: 50px;',
                'min'   => -1,
            ),
            'label'             => esc_html__( 'No of Products', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'number',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_woo_products_showcase_columns',
            'default'            => 4,
            'sanitize_callback'  => 'wen_travel_sanitize_number_range',
            'active_callback'    => 'wen_travel_is_woo_products_showcase_active',
            'description'        => esc_html__( 'Theme supports up to 4 columns', 'wen-travel-pro' ),
            'label'              => esc_html__( 'No of Columns', 'wen-travel-pro' ),
            'section'            => 'wen_travel_woo_products_showcase',
            'type'               => 'number',
            'input_attrs'       => array(
                'style' => 'width: 50px;',
                'min'   => 1,
                'max'   => 4,
            ),
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_woo_products_showcase_paginate',
            'default'            => 'false',
            'sanitize_callback'  => 'wen_travel_sanitize_select',
            'active_callback'    => 'wen_travel_is_woo_products_showcase_active',
            'label'              => esc_html__( 'Paginate', 'wen-travel-pro' ),
            'section'            => 'wen_travel_woo_products_showcase',
            'type'               => 'radio',
            'choices'            => array(
                'false' => esc_html__( 'No', 'wen-travel-pro' ),
                'true' => esc_html__( 'Yes', 'wen-travel-pro' ),
            ),
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_woo_products_showcase_orderby',
            'default'            => 'title',
            'sanitize_callback'  => 'wen_travel_sanitize_select',
            'active_callback'    => 'wen_travel_is_woo_products_showcase_active',
            'label'              => esc_html__( 'Order By', 'wen-travel-pro' ),
            'section'            => 'wen_travel_woo_products_showcase',
            'type'               => 'select',
            'choices'            => array(
                'date'       => esc_html__( 'Date - The date the product was published', 'wen-travel-pro' ),
                'id'         => esc_html__( 'ID - The post ID of the product', 'wen-travel-pro' ),
                'menu_order' => esc_html__( 'Menu Order - The Menu Order, if set (lower numbers display first)', 'wen-travel-pro' ),
                'popularity' => esc_html__( 'Popularity - The number of purchases', 'wen-travel-pro' ),
                'rand'       => esc_html__( 'Random', 'wen-travel-pro' ),
                'rating'     => esc_html__( 'Rating - The average product rating', 'wen-travel-pro' ),
                'title'      => esc_html__( 'Title - The product title', 'wen-travel-pro' ),
            ),
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_woo_products_showcase_products_filter',
            'default'            => 'none',
            'sanitize_callback'  => 'wen_travel_sanitize_select',
            'active_callback'    => 'wen_travel_is_woo_products_showcase_active',
            'label'              => esc_html__( 'Products Filter', 'wen-travel-pro' ),
            'section'            => 'wen_travel_woo_products_showcase',
            'type'               => 'radio',
            'choices'            => array(
                'none'         => esc_html__( 'None', 'wen-travel-pro' ),
                'on_sale'      => esc_html__( 'Retrieve on sale products', 'wen-travel-pro' ),
                'best_selling' => esc_html__( 'Retrieve best selling products', 'wen-travel-pro' ),
                'top_rated'    => esc_html__( 'Retrieve top rated products', 'wen-travel-pro' ),
            ),
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_featured',
            'sanitize_callback' => 'wen_travel_sanitize_checkbox',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Show only Products that are marked as Featured Products', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'               => 'wen_travel_woo_products_showcase_order',
            'default'            => 'ASC',
            'sanitize_callback'  => 'wen_travel_sanitize_select',
            'active_callback'    => 'wen_travel_is_woo_products_showcase_active',
            'label'              => esc_html__( 'Order', 'wen-travel-pro' ),
            'section'            => 'wen_travel_woo_products_showcase',
            'type'               => 'radio',
            'choices'            => array(
                'ASC'  => esc_html__( 'Ascending', 'wen-travel-pro' ),
                'DESC' => esc_html__( 'Descending', 'wen-travel-pro' ),
            ),
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_skus',
            'description'       => esc_html__( 'Comma separated list of product SKUs', 'wen-travel-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'SKUs', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'text',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_category',
            'description'       => esc_html__( 'Comma separated list of category slugs', 'wen-travel-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Category', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'textarea',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_text',
            'default'           => esc_html__( 'Go to Shop Page', 'wen-travel-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Button Text', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'type'              => 'text',
        )
    );
    $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_link',
            'default'           =>  esc_url( $shop_page_url ),
            'sanitize_callback' => 'esc_url_raw',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Button Link', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
        )
    );

    wen_travel_register_option( $wp_customize, array(
            'name'              => 'wen_travel_woo_products_showcase_target',
            'sanitize_callback' => 'wen_travel_sanitize_checkbox',
            'active_callback'   => 'wen_travel_is_woo_products_showcase_active',
            'label'             => esc_html__( 'Open Link in New Window/Tab', 'wen-travel-pro' ),
            'section'           => 'wen_travel_woo_products_showcase',
            'custom_control'    => 'Wen_Travel_Toggle_Control',
        )
    );
}
add_action( 'customize_register', 'wen_travel_woo_products_showcase', 10 );

/** Active Callback Functions **/
if ( ! function_exists( 'wen_travel_is_woo_products_showcase_active' ) ) :
    /**
    * Return true if featured content is active
    *
    * @since Wen Travel Pro 1.0
    */
    function wen_travel_is_woo_products_showcase_active( $control ) {
        $enable = $control->manager->get_setting( 'wen_travel_woo_products_showcase_option' )->value();

        return wen_travel_check_section( $enable );
    }
endif;
