<?php
/**
 * Class for Demo Import
 *
 * @package Education_Hub
 */

/**
 * Demo Import class.
 *
 * @since 1.1
 */
class Signify_Demo_Import {

	function __construct() {
		add_filter( 'cp-ctdi/import_files', array( $this, 'import_files' ) );
		add_action( 'cp-ctdi/after_import', array( $this, 'after_import_setup' ) );
		add_filter( 'ocdi/import_files', array( $this, 'import_files' ) );
		add_action( 'ocdi/after_import', array( $this, 'after_import_setup' ) );
	}

	function import_files() {
		return array(
			array(
				'import_file_name'           => esc_html__( 'WEN Travel Pro', 'wen-travel-pro' ),
				'import_file_url'            => get_template_directory_uri() . '/inc/support/ctdi/wen-travel-pro.xml',
				'import_widget_file_url'     => get_template_directory_uri() . '/inc/support/ctdi/wen-travel-pro.wie',
				'import_customizer_file_url' => get_template_directory_uri() . '/inc/support/ctdi/wen-travel-pro.dat',
				'import_preview_image_url'   => get_template_directory_uri() . '/inc/support/ctdi/wen-travel-pro.jpg',
				'preview_url'                => 'https://demo.wenthemes.com/wen-travel-pro/',
			),
		);
	}

	function after_import_setup() {

		// Assign menus to their locations.
		$main_menu       = get_term_by( 'name', 'Main Menu', 'nav_menu' );
		$social_menu     = get_term_by( 'name', 'Social Menu', 'nav_menu' );
		$header_top_menu = get_term_by( 'name', 'Quick Links', 'nav_menu' );
		$social_top_menu = get_term_by( 'name', 'Social Menu', 'nav_menu' );
		set_theme_mod(
			'nav_menu_locations',
			array(
				'menu-top'      => $header_top_menu->term_id,
				'social-top'    => $social_top_menu->term_id,
				'menu-1'        => $main_menu->term_id,
				'social-footer' => $social_menu->term_id,
			)
		);

		// Assign front page and posts page (blog page).
		$front_page_id = get_page_by_title( 'Front Page' );
		$blog_page_id  = get_page_by_title( 'Blog' );
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );
	}
}

// Initialize.
$education_hub_ctdi = new Signify_Demo_Import();
