/* global wenTravelColorMain, Color */
/**
 * Add a listener to the Color Scheme control to update other color controls to new values/defaults.
 * Also trigger an update of the Color Scheme CSS when a color is changed.
 */

( function( api ) {
	var colorScheme  = wenTravelColorMain.colorScheme;
	var colorOptions = wenTravelColorMain.colorOptions;

	api.controlConstructor.select = api.Control.extend( {
		ready: function() {
			if ( 'color_scheme' === this.id ) {
				this.setting.bind( 'change', function( value ) {
					var colors = colorScheme[value].colors;

					jQuery.each( colorOptions, function( index, value ) {
						api( value ).set( colors[value] );
						api.control( value ).container.find( '.color-picker-hex' )
							.data( 'data-default-color', colors[value] )
                            .wpColorPicker( 'defaultColor', colors[value] );
					});
				} );
			}

			// Theme Scheme.
			if ( 'theme_scheme'=== this.id ) {
				this.setting.bind( 'change', function( value ) {
					if ( 'default' === value ) {
						api( 'color_scheme' ).set( 'dark' );
						api( 'color_scheme' ).set( 'default' );
						api( 'wen_travel_header_style' ).set( 'style-one' );
						api( 'wen_travel_disable_header_top' ).set( '0' );
						api( 'wen_travel_transparent_header' ).set( '1' );
						api( 'wen_travel_header_media_text_alignment' ).set( 'text-align-center' );
						api( 'wen_travel_header_media_content_alignment' ).set( 'content-align-center' );
						api( 'wen_travel_menu_type' ).set( 'classic' );
						api( 'wen_travel_social_menu_left' ).set( '0' );
						api( 'wen_travel_gradient_button' ).set( '0' );
						api( 'wen_travel_collection_number' ).set( '4' );
					} else if ( 'modern' === value ) {
						api( 'color_scheme' ).set( 'dark' );
						api( 'color_scheme' ).set( 'default' );
						api( 'wen_travel_header_style' ).set( 'style-two' );
						api( 'wen_travel_disable_header_top' ).set( '1' );
						api( 'wen_travel_transparent_header' ).set( '1' );
						api( 'wen_travel_header_media_text_alignment' ).set( 'text-align-center' );
						api( 'wen_travel_header_media_content_alignment' ).set( 'content-align-center' );
						api( 'wen_travel_menu_type' ).set( 'classic' );
						api( 'wen_travel_social_menu_left' ).set( '1' );
						api( 'wen_travel_gradient_button' ).set( '0' );
						api( 'wen_travel_collection_number' ).set( '4' );
					} else if ( 'blog' === value ) {
						api( 'color_scheme' ).set( 'default' );
						api( 'color_scheme' ).set( 'blog' );
						api( 'wen_travel_header_style' ).set( 'style-two' );
						api( 'wen_travel_disable_header_top' ).set( '0' );
						api( 'wen_travel_transparent_header' ).set( '0' );
						api( 'wen_travel_header_media_text_alignment' ).set( 'text-align-center' );
						api( 'wen_travel_header_media_content_alignment' ).set( 'content-align-center' );
						api( 'wen_travel_menu_type' ).set( 'classic' );
						api( 'wen_travel_social_menu_left' ).set( '0' );
						api( 'wen_travel_gradient_button' ).set( '0' );
						api( 'wen_travel_collection_number' ).set( '4' );
					} else if ( 'photography' === value ) {
						api( 'color_scheme' ).set( 'default' );
						api( 'color_scheme' ).set( 'photography' );
						api( 'wen_travel_header_style' ).set( 'style-two' );
						api( 'wen_travel_disable_header_top' ).set( '0' );
						api( 'wen_travel_transparent_header' ).set( '1' );
						api( 'wen_travel_header_media_text_alignment' ).set( 'text-align-left' );
						api( 'wen_travel_header_media_content_alignment' ).set( 'content-align-left' );
						api( 'wen_travel_menu_type' ).set( 'modern' );
						api( 'wen_travel_social_menu_left' ).set( '0' );
						api( 'wen_travel_gradient_button' ).set( '1' );
						api( 'wen_travel_collection_number' ).set( '9' );
					} else if ( 'corporate' === value ) {
						api( 'color_scheme' ).set( 'default' );
						api( 'color_scheme' ).set( 'corporate' );
						api( 'wen_travel_header_style' ).set( 'style-two' );
						api( 'wen_travel_disable_header_top' ).set( '1' );
						api( 'wen_travel_transparent_header' ).set( '0' );
						api( 'wen_travel_header_media_text_alignment' ).set( 'text-align-center' );
						api( 'wen_travel_header_media_content_alignment' ).set( 'content-align-center' );
						api( 'wen_travel_menu_type' ).set( 'classic' );
						api( 'wen_travel_social_menu_left' ).set( '0' );
						api( 'wen_travel_gradient_button' ).set( '0' );
						api( 'wen_travel_collection_number' ).set( '4' );
					}
				});
			}
		}
	} );
} )( wp.customize );
