/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	api = wp.customize;

	// Site title and description.
	api( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		});
	});
	api( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		});
	});

	// Header text color without header media background.
	api( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				});
			} else {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative',
					'color': to
				});
			}
		});
	});

	// Color Options for customizer.
	$.each( wenTravelColorOptions, function( key, value ) {
		api( key, function( inner_value ) {
			inner_value.bind( function( to ) {
				if ( value.is_gradient ) {
					if ( key.indexOf("_next") >= 0 ) {
						value1 = api( key.replace( /_next/g,'') ).get(); 
						value2 = to;

						option = key.replace( /_next/g,'');
					} else {
						value1 = to;
						value2 = api( key + '_next' ).get();

						option = key;
					}

					css = wenTravelColorOptions[option].css.replace( /%1\$s/g, value1 );
					css = css.replace( /%2\$s/g, value2 );
				} else {
					css = value.css.replace( /%1\$s/g, to );
				}

				$('head').append( '<style>' + css + '</style>' );
			});
		});
	});

	// Color Scheme color.
	api( 'color_scheme', function( value ) {
		value.bind( function( to ) {
			$( 'body' ).removeClass( 'color-scheme-default color-scheme-dark color-scheme-red' );
			$( 'body' ).addClass( 'color-scheme-' + to );
		});
	});

	// // Theme Scheme.
	// api( 'theme_scheme', function( value ) {
	// 	value.bind( function( to ) {
	// 		$( 'body' ).removeClass( 'theme-scheme-default theme-scheme-personal theme-scheme-corporate theme-scheme-portfolio theme-scheme-photography theme-scheme-music theme-scheme-wedding theme-scheme-eTravel' );
	// 		$( 'body' ).addClass( 'theme-scheme-' + to );
	// 	});
	// });
})( jQuery );
