<?php
/**
 * The template for displaying Attraction items
 *
 * @package WEN_Travel
 */

$wen_travel_enable = get_theme_mod( 'wen_travel_attraction_option', 'disabled' );

if ( ! wen_travel_check_section( $wen_travel_enable ) ) {
	// Bail if attraction section is disabled.
	return;
}

$wen_travel_type        = get_theme_mod( 'wen_travel_attraction_type', 'category' );
$wen_travel_title       = get_theme_mod( 'wen_travel_attraction_title');
$wen_travel_description = get_theme_mod( 'wen_travel_attraction_description' );
$wen_travel_bg_image  	= get_theme_mod( 'wen_travel_attraction_bg_image' );

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$wen_travel_classes[] = 'no-section-heading';
}

$wen_travel_classes[] = 'layout-three';
$wen_travel_classes[] = $wen_travel_type;
$wen_travel_classes[] = 'section';

if ( $wen_travel_bg_image ) {
	$wen_travel_classes[] = 'has-background-image';
}
?>

<div id="attraction-content-section" class="attraction-content-section <?php echo esc_attr( implode( ' ', $wen_travel_classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">
				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper attraction-content-wrapper layout-three">

			<?php if ( 'category' === $wen_travel_type && ! empty( $wen_travel_cats = get_theme_mod( 'wen_travel_attraction_select_category' ) ) ) : ?>
						<div class="filter-button-group button-group js-radio-button-group">
							<button class="button is-checked" data-filter="*"><?php esc_html_e( 'All', 'wen-travel-pro' ) ?></button>
							<?php
							foreach ( $wen_travel_cats as $wen_travel_cat ) {
								$wen_travel_catinfo = get_category( $wen_travel_cat );
								$wen_travel_catslug = isset( $wen_travel_catinfo->slug ) ? $wen_travel_catinfo->slug : '';
								$wen_travel_catname = isset( $wen_travel_catinfo->name ) ? $wen_travel_catinfo->name : '';
								?>
								<button class="button" data-filter=".<?php echo esc_attr( $wen_travel_catslug ); ?>"><?php echo esc_html( $wen_travel_catname ); ?></button>
								<?php
							}
						    ?>
						</div>
			<?php endif;?>

			<div class="grid">
				<div class="grid-sizer"></div>
					<?php
					if ( 'custom' === $wen_travel_type ) {
						get_template_part( 'template-parts/attraction/image', 'attraction' );
					} else {
						get_template_part( 'template-parts/attraction/post-types', 'attraction' );
					}
					?>
			</div><!-- .project-masonry -->
		</div><!-- .section-content-wrap -->

		<?php
			$wen_travel_target = get_theme_mod( 'wen_travel_attraction_target' ) ? '_blank': '_self';
			$wen_travel_link   = get_theme_mod( 'wen_travel_attraction_link', '#' );
			$wen_travel_text   = get_theme_mod( 'wen_travel_attraction_text' );

			if ( $wen_travel_text ) :
		?>

		<p class="view-more">
			<a class="button" target="<?php echo $wen_travel_target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $wen_travel_text ); ?></a>
		</p>
		<?php endif; ?>
	</div><!-- .wrapper -->
</div><!-- #attraction-section -->
