<?php
/**
 * The template for displaying collection items
 *
 * @package WEN_Travel
 */
?>

<?php
$number = get_theme_mod( 'wen_travel_collection_number', 4 );

if ( ! $number ) {
	// If number is 0, then this section is disabled
	return;
}

$slider_select = get_theme_mod( 'wen_travel_collection_slider', 1 );

for ( $i = 1; $i <= $number; $i++ ) {
	$target = get_theme_mod( 'wen_travel_collection_target_' . $i ) ? '_blank': '_self';
	$wen_travel_title  = get_theme_mod( 'wen_travel_collection_title_' . $i );
	$wen_travel_sub_title = get_theme_mod( 'wen_travel_collection_sub_title_' . $i );
	$image  = get_theme_mod( 'wen_travel_collection_image_' . $i ) ? get_theme_mod( 'wen_travel_collection_image_' . $i ) :  trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-508x522.jpg';
	$wen_travel_link   = get_theme_mod( 'wen_travel_collection_link_' . $i, '#' );

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	$classes = 'grid-item';

	if ( 1 === $i || 5 === $i ) {
		$classes .= ' wide';
		$image  = get_theme_mod( 'wen_travel_collection_image_' . $i ) ? get_theme_mod( 'wen_travel_collection_image_' . $i ) :  trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-920x433.jpg';
	} 

	?>
	<article id="collection-post-<?php echo esc_attr( $i ) ?>" class="hentry post-image <?php echo esc_attr( $classes ); ?>">
		<div class="hentry-inner">
			<div class="collection-thumbnail post-thumbnail">
				<?php if ( $wen_travel_link ) : ?>
				<a class="post-thumbnail" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo $target; ?>">
				<?php endif; ?>
					<img src="<?php echo esc_url( $image ); ?>" class="wp-post-image" alt="<?php echo esc_attr( $wen_travel_title ); ?>" title="<?php echo esc_attr( $wen_travel_title ); ?>">
				<?php if ( $wen_travel_link ) : ?>
				</a>
				<?php endif; ?>
			</div>

			<div class="entry-container caption">
				<div class="entry-container-inner-wrap">
					<?php
					if ( $wen_travel_title ) : ?>
					<header class="entry-header">
						<h2 class="entry-title">
							<?php if ( $wen_travel_link ) : ?>
							<a class="post-thumbnail" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo $target; ?>">
							<?php endif; ?>
								<?php echo wp_kses_post( $wen_travel_title ); ?>
							<?php if ( $wen_travel_link ) : ?>
							</a>
							<?php endif; ?>
						</h2>
					</header>
					<?php endif; ?>
					
					<?php if ( $wen_travel_sub_title ) : ?>
						<div class="sub-title">
							<?php echo wp_kses_post( $wen_travel_sub_title ); ?>
						</div>
					<?php endif; ?>
				</div><!-- .entry-container-inner-wrap -->	
			</div><!-- .entry-container -->
		</div><!-- .hentry-inner -->
	</article>
<?php
}
