<?php
/**
 * The template for displaying Contact Info
 *
 * @package WEN_Travel
 */

$enable = get_theme_mod( 'wen_travel_contact_option', 'disabled' );

if ( ! wen_travel_check_section( $enable ) ) {
	// Bail if contact section is disabled.
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_contact_type', 'page' );

if ( 'post' === $wen_travel_type && 'publish' === get_post_status( get_theme_mod( 'wen_travel_contact_post' ) ) ) {
	$background = get_the_post_thumbnail_url( get_theme_mod( 'wen_travel_contact_post' ) );
} elseif ( 'page' === $wen_travel_type  && 'publish' === get_post_status( get_theme_mod( 'wen_travel_contact_page' ) ) ) {
	$background = get_the_post_thumbnail_url( get_theme_mod( 'wen_travel_contact_page' ) );
} elseif ( 'custom' === $wen_travel_type ) {
	$background = get_theme_mod( 'wen_travel_contact_bg_image' ); 
}
?> 	
<div id="contact-section" class="contact-section section<?php echo $background ? ' has-background-image' : ''; ?>">
	<div class="wrapper">
		<div class="section-content-wrapper contact-content-wrapper">
			<?php
			$wen_travel_type  = get_theme_mod( 'wen_travel_contact_type', 'page' ); 
			$wen_travel_title = '';
			?>
			<article class="hentry contact-us-form">
				<div class="left-content">
					<div class="left-content-offer">
						<div class="price-offer">
							<?php if ( $wen_travel_price_title = get_theme_mod( 'wen_travel_contact_left_title', esc_html__( 'special offer', 'wen-travel-pro' ) ) ) : ?>
							<h2 class="entry-title"><?php echo esc_html( $wen_travel_price_title ); ?></h2>
							<?php endif; ?>
							
							<?php
							$wen_travel_price_currency    = get_theme_mod( 'wen_travel_contact_left_currency', esc_html__( '$', 'wen-travel-pro' ) );
							$wen_travel_price_amount      = get_theme_mod( 'wen_travel_contact_left_amount', esc_html__( '199', 'wen-travel-pro' ) );
							$wen_travel_price_per_person  = get_theme_mod( 'wen_travel_contact_left_per_person', esc_html__( 'per person', 'wen-travel-pro' ) );
							$wen_travel_price_description = get_theme_mod( 'wen_travel_contact_left_description', esc_html__( '3 nights stay at Fiji Island air fair not included', 'wen-travel-pro' ) );

							if ( $wen_travel_price_currency || $wen_travel_price_amount || $wen_travel_price_per_person || $wen_travel_price_description ) : ?>
							<div class="price-per-person">
								<?php if ( $wen_travel_price_currency || $wen_travel_price_amount ) : ?>
								<div class="price">
									<span class="currency"><?php echo esc_html( $wen_travel_price_currency ); ?></span><span class="amount"><?php echo esc_html( $wen_travel_price_amount ); ?></span>
								</div>
								<?php endif; ?>

								<?php if ( $wen_travel_price_per_person || $wen_travel_price_description ) : ?>
								<div class="price-content">
									<strong><?php echo esc_html( $wen_travel_price_per_person ); ?></strong>
									
									<?php echo wp_kses_post( wpautop( $wen_travel_price_description ) ); ?>
								</div>
								<?php endif; ?>
							</div>
							<?php endif; ?>

							<?php
							$wen_travel_offer_title      = get_theme_mod( 'wen_travel_contact_left_offer_title', esc_html__( 'offer includes', 'wen-travel-pro' ) );
							$wen_travel_offer_description  = get_theme_mod( 'wen_travel_contact_left_offer_description', esc_html__( 'lorem ipsum dolor sit amet
concestetur lorem ipsum
amazing travel WP theme
lorem ipsum dolor sit amet
concestetur lorem ipsum
amazing travel WP theme', 'wen-travel-pro' ) );
							
							$wen_travel_offer_link_text          = get_theme_mod( 'wen_travel_contact_left_offer_link_text', esc_html__( 'for more info call 1.124.567.8912', 'wen-travel-pro' ) );	

							if ( $wen_travel_offer_title || $wen_travel_offer_description || $wen_travel_offer_link_text ) : ?>
							<div class="offer-lists">
								<?php if ( $wen_travel_offer_title ) : ?>
									<h2 class="entry-title"><?php echo esc_html( $wen_travel_offer_title ); ?></h2>
								<?php endif; ?>
								
								<?php if ( $wen_travel_offer_description ) : ?>
								<ul>
									<?php 
									echo str_replace( '<li>', '<li>' . wen_travel_get_svg( array( 'icon' => 'angle-right' ) ) , '<li>' . wp_kses_post( str_replace( array( PHP_EOL, "\n", '<br />' ), '</li><li>', $wen_travel_offer_description ) ) . '</li>' ); ?>
								</ul>
								<?php endif; ?>

								<?php
									if ( $wen_travel_offer_link_text ) :
										$wen_travel_offer_target = get_theme_mod( 'wen_travel_contact_left_offer_target' ) ? '_blank': '_self';
										$wen_travel_offer_link   = get_theme_mod( 'wen_travel_contact_left_offer_link', '#' );
									?>
									<a target="<?php echo $wen_travel_offer_target; ?>" href="<?php echo esc_url( $wen_travel_offer_link ); ?>"><?php echo esc_html( $wen_travel_offer_link_text ); ?></a>
								<?php endif; ?>
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>	
				
				<div class="entry-container">
					<div class="inner-container">
						<?php
						$inner_content = '';
						$wen_travel_description = get_theme_mod( 'wen_travel_contact_description' );

						if ( 'post' === $wen_travel_type && 'publish' === get_post_status( get_theme_mod( 'wen_travel_contact_post' ) ) ) {
							$post_object = get_post( get_theme_mod( 'wen_travel_contact_post' ) );

							$inner_content = apply_filters( 'the_content', $post_object->post_content );
							$wen_travel_title         = $post_object->post_title; 
						} elseif ( 'page' === $wen_travel_type  && 'publish' === get_post_status( get_theme_mod( 'wen_travel_contact_page' ) ) ) {
							$post_object = get_post( get_theme_mod( 'wen_travel_contact_page' ) );

							$inner_content = apply_filters( 'the_content', $post_object->post_content );
							$wen_travel_title         = $post_object->post_title;
						} elseif ( 'custom' === $wen_travel_type ) {
							$inner_content    = get_theme_mod( 'wen_travel_contact_custom' );
							$wen_travel_title = get_theme_mod( 'wen_travel_contact_title', esc_html__( 'Let\'s get in touch', 'wen-travel-pro' ) ); 
						}
						
						if ( $wen_travel_title ) : ?>
							<header class="entry-header">
								<h2 class="entry-title "><?php echo esc_html( $wen_travel_title ); ?></h2>
							</header>
						<?php endif; ?>

						<?php if ( $wen_travel_description ) : ?>
							<div class="section-description">
								<p>
									<?php
										echo wp_kses_post( $wen_travel_description );
									?>
								</p>
							</div><!-- .section-description-wrapper -->
						<?php endif; ?>

						<div class="entry-content">
							<?php echo do_shortcode( $inner_content );?> 
						</div>
					</div><!-- .inner-container -->
				</div><!-- .entry-container -->
			</article><!-- .hentry -->	
		</div>
	</div><!-- .wrapper -->
</div><!-- .section -->
