<?php
/**
 * The template for displaying featured content
 *
 * @package Wen Travel
 */

$wen_travel_enable_content = get_theme_mod( 'wen_travel_countdown_option', 'disabled' );

if ( ! wen_travel_check_section( $wen_travel_enable_content ) ) {
	// Bail if featured content is disabled.
	return;
}
$wen_travel_content_position = get_theme_mod( 'wen_travel_countdown_content_position', 'content-align-left' );
$wen_travel_text_align       = get_theme_mod( 'wen_travel_countdown_text_alignment', 'text-align-left' );

$wen_travel_classes[] = 'section countdown-section';
$wen_travel_classes[] = $wen_travel_content_position;
$wen_travel_classes[] = $wen_travel_text_align;

$thumbnail_image        = get_theme_mod( 'wen_travel_countdown_thumbnail_image' ) ? get_theme_mod( 'wen_travel_countdown_thumbnail_image' ) : trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-800x533.jpg';
$wen_travel_title       = get_theme_mod( 'wen_travel_countdown_section_title' , esc_html__( 'Countdown', 'wen-travel-pro' ) );
$wen_travel_description = get_theme_mod( 'wen_travel_countdown_section_description' );
$left_title 		    = get_theme_mod( 'wen_travel_countdown_title' );
$left_description       = get_theme_mod( 'wen_travel_countdown_description' );
$normal_price  	        = get_theme_mod( 'wen_travel_countdown_normal_price' );
$offer_price  	        = get_theme_mod( 'wen_travel_countdown_offer_price' );
$offer_text 	        = get_theme_mod( 'wen_travel_countdown_offer_text' );

if( ! $wen_travel_title && ! $wen_travel_description && ! $wen_travel_tagline ) {
 	$wen_travel_class = 'no-section-heading';
}
?>

<div id="countdown-section" class="<?php echo esc_attr( implode( ' ', $wen_travel_classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
        	<div class="section-heading-wrapper">
        		<?php if ( $wen_travel_title ) : ?>
        			<div class="section-title-wrapper">
        				<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
        			</div><!-- .page-title-wrapper -->
        		<?php endif; ?>

        		<?php if ( $wen_travel_description ) : ?>
        			<div class="section-description">
        				<p>
        					<?php
        						echo wp_kses_post( $wen_travel_description );
        					?>
        				</p>
        			</div><!-- .section-description-wrapper -->
        		<?php endif; ?>
        	</div>
        <?php endif; ?>
        
        <div class="section-content-wrapper countdown-content-wrapper">
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="hentry-inner">
					<div class="entry-container">
						<div class="content-wrapper">

						<?php if ( $left_title || $left_description || $normal_price ||$offer_price ) : ?>
							<div class="content-left">
								<h2 class="content-title">
									<?php echo wp_kses_post( $left_title ); ?>
								</h2>

								<div class="content-description">
									<p>
										<?php echo wp_kses_post( wpautop( $left_description ) ); ?>
									</p>
								</div><!-- .section-description-wrapper -->

								<div class="price">
									<p>
										<span class="normal-price"><?php echo esc_html( $normal_price ); ?></span>
										<span class="offer-price"><?php echo esc_html( $offer_price ); ?></span>
										<span class="offer-text"><?php echo esc_html( $offer_text ); ?></span>
									</p>
								</div>

								<?php
									$wen_travel_link = get_theme_mod( 'wen_travel_countdown_link', '#' );
									$wen_travel_text = get_theme_mod( 'wen_travel_countdown_button_text' );

									if ( $wen_travel_text ) :
									?>
									<a class="more-link" href="<?php echo esc_url( $wen_travel_link ); ?>" target="_self">
										<span><?php echo esc_html( $wen_travel_text ); ?></span>
									</a>
								<?php endif; ?>
							</div>
						<?php endif; ?>	

							<div class="content-right">
								<div class="entry-content">
									<div class="post-thumbnail">
										<img src="<?php echo esc_url( $thumbnail_image ); ?>">
										<div id="clock"></div>
									</div>
								</div><!-- .entry-content -->
							</div>
						</div><!-- .content-wrapper -->
					</div><!-- .entry-container -->
				</div><!-- .hentry-inner -->
			</article><!-- #post-## -->
		</div>
	</div><!-- .wrapper -->
</div><!-- .section -->
