<?php
/**
 * The template for displaying featured image content
 *
 * @package WEN_Travel
 */

$thumbnail_style = get_theme_mod( 'wen_travel_featured_content_thumbnail_style', 'style-one' );
$quantity 	     = get_theme_mod( 'wen_travel_featured_content_number', 3 );

for ( $i = 1; $i <= $quantity; $i++ ) {
	$target = get_theme_mod( 'wen_travel_featured_content_target_' . $i ) ? '_blank' : '_self';

	$wen_travel_link = get_theme_mod( 'wen_travel_featured_content_link_' . $i ) ? get_theme_mod( 'wen_travel_featured_content_link_' . $i ) : '#';

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	echo '
	<article id="featured-post-' . esc_attr( $i ) . '" class="hentry featured-image-content">
		<div class="hentry-inner">';

			$wen_travel_title   = get_theme_mod( 'wen_travel_featured_content_title_' . $i );
			$content = get_theme_mod( 'wen_travel_featured_content_content_' . $i );

			$image = get_theme_mod( 'wen_travel_featured_content_image_' . $i ) ? get_theme_mod( 'wen_travel_featured_content_image_' . $i ) : '';

			if( 'style-one' === $thumbnail_style ) :
				$image = get_theme_mod( 'wen_travel_featured_content_image_' . $i ) ? get_theme_mod( 'wen_travel_featured_content_image_' . $i ) :  trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-508x338.jpg';

			if( $image ) {
				echo '<div class="post-thumbnail">
					<a class="cover-link" href="' . esc_url( $wen_travel_link ) . '">
						<img src="' . esc_url( $image ) . '">
					</a>
					<header class="entry-header">					
						<h2 class="entry-title">
							<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark">
							' . esc_html( $wen_travel_title ) . '
							</a>
						</h2> 
					</header>
				</div>'; 
			} 
			endif;


			if( 'style-two' === $thumbnail_style ) :
				$image = get_theme_mod( 'wen_travel_featured_content_image_' . $i ) ? get_theme_mod( 'wen_travel_featured_content_image_' . $i ) : '';

				if ( $image ) {
					echo '
					<a href="' . esc_url( $wen_travel_link ) . '" class="post-thumbnail" target="' . esc_attr( $target ) . '">
						<img src="' . esc_url( $image ) . '" class="wp-post-image" alt="' . esc_attr( $wen_travel_title ) . '" title="' . esc_attr( $wen_travel_title ) . '">
					</a>';
				}
			endif;
			
			if ( $wen_travel_title || $content ) {
				echo '
				<div class="entry-container">';

				if ( $wen_travel_title && 'style-two' === $thumbnail_style ) {
					echo '
					<header class="featured-content entry-header">
						<h2 class="entry-title">
							<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . wp_kses_post( $wen_travel_title ) . '</a>
						</h2>
					</header>';
				}

				$button_text = get_theme_mod( 'wen_travel_featured_content_button_text_' . $i );

				if ( '' !== $content || $button_text ) {
					echo '
					<div class="entry-summary">' . wp_kses_post( apply_filters( 'the_content', $content ) ) . '
					<a href="' . $wen_travel_link . '" class="more-link">' . $button_text . '</a>
					</div><!-- .entry-summary -->';
				}

				echo '
				</div><!-- .entry-container -->';
			}

		echo '
		</div><!-- .hentry-inner -->
	</article><!-- .featured-post-' . esc_attr( $i ) . ' -->';
} // End for().
