<?php
/**
 * The template for displaying featured content
 *
 * @package WEN_Travel
 */
?>

<?php
$enable_content = get_theme_mod( 'wen_travel_featured_content_option', 'disabled' );

if ( ! wen_travel_check_section( $enable_content ) ) {
	// Bail if featured content is disabled.
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_featured_content_type', 'category' );

if ( 'featured-content' === $wen_travel_type ) {
	$wen_travel_title       = get_option( 'featured_content_title', esc_html__( 'Contents', 'wen-travel-pro' ) );
	$wen_travel_description = get_option( 'featured_content_content' );
} else {
	$wen_travel_title       = get_theme_mod( 'wen_travel_featured_content_title' );
	$wen_travel_description = get_theme_mod( 'wen_travel_featured_content_description' );
}

$layout = get_theme_mod( 'wen_travel_featured_content_layout', 'layout-three' );

$classes[] = $layout;
$classes[] = $wen_travel_type;
$classes[] = 'section';
$classes[] = 'ghost-button';

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}
?>

<div id="featured-content-section" class="featured-content-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">

				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper featured-content-wrapper <?php echo esc_attr( $layout ); ?>">
			<?php
				if ( 'custom' === $wen_travel_type ) {
					get_template_part( 'template-parts/featured-content/custom-featured' );
				} else {
					get_template_part( 'template-parts/featured-content/content-featured' );
				}
			?>
		</div><!-- .section-content-wrap -->

		<?php
			$target        = get_theme_mod( 'wen_travel_featured_content_target' ) ? '_blank': '_self';
			$wen_travel_link = get_theme_mod( 'wen_travel_featured_content_link', '#' );
			$text          = get_theme_mod( 'wen_travel_featured_content_text' );

			if ( $text ) :
			?>
			<p class="view-more">
				<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
			</p>
		<?php endif; ?>
	</div><!-- .wrapper -->
</div><!-- #featured-content-section -->
