<?php
/**
 * The template used for displaying gallery
 *
 * @package WEN_Travel
 */
$wen_travel_type        = get_theme_mod( 'wen_travel_gallery_type', 'page' );
$wen_travel_description = get_theme_mod( 'wen_travel_gallery_description' );

if ( 'page' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_gallery' ) ) {
	$args['page_id'] = absint( $wen_travel_id );
} elseif ( 'post' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_gallery_post' ) ) {
	$args['p'] = absint( $wen_travel_id );
} elseif ( 'category' === $wen_travel_type && $wen_travel_cat = get_theme_mod( 'wen_travel_gallery_category' ) ) {
	$args['cat'] = absint( $wen_travel_cat );
	$args['posts_per_page'] = 1;
}

// If $args is empty return false
if ( empty( $args ) ) {
	return;
}

// Create a new WP_Query using the argument previously created
$gallery_query = new WP_Query( $args );
if ( $gallery_query->have_posts() ) :
	while ( $gallery_query->have_posts() ) :
		$gallery_query->the_post();

		$classes = array();
		
		if ( ! get_theme_mod( 'wen_travel_display_gallery_title' ) ) {
			$classes[] = 'no-section-heading';
		}
		$text   = get_theme_mod( 'wen_travel_gallery_text' );
		if ( '' == $text ) {
			$classes[] = 'no-view-more-button';
		}
		?>
		<div id="gallery-section" class="gallery-section section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
			<div class="wrapper">
				<?php if ( get_theme_mod( 'wen_travel_display_gallery_title' ) || $wen_travel_description ) : ?>
					<div class="section-heading-wrapper">

						<?php if ( get_theme_mod( 'wen_travel_display_gallery_title' ) ) : ?>
							<div class="section-title-wrapper">
								<h2 class="section-title"wen_travel_><?php the_title(); ?></h2>
							</div><!-- .page-title-wrapper -->
						<?php endif; ?>

						<?php if ( $wen_travel_description ) : ?>
							<div class="section-description">
								<p>
									<?php
										echo wp_kses_post( $wen_travel_description );
									?>
								</p>
							</div><!-- .section-description-wrapper -->
						<?php endif; ?>
					</div><!-- .section-heading-wrapper -->
				<?php endif; ?>

				<div class="section-content-wrapper gallery-content-wrapper">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="hentry-inner">
							<div class="entry-container">
								<div class="entry-content">
									<?php the_content(); ?>
								</div><!-- .entry-content -->

								<?php if ( get_edit_post_link() ) : ?>
									<footer class="entry-footer">
										<div class="entry-meta">
											<?php
												edit_post_link(
													sprintf(
														/* translators: %s: Name of current post */
														esc_html__( 'Edit %s', 'wen-travel-pro' ),
														the_title( '<span class="screen-reader-text">"', '"</span>', false )
													),
													'<span class="edit-link">',
													'</span>'
												);
											?>
										</div>	<!-- .entry-meta -->
									</footer><!-- .entry-footer -->
								<?php endif; ?>
							</div><!-- .entry-container -->
						</div><!-- .hentry-inner -->
					</article>
				</div><!-- .section-content-wrapper -->
			</div><!-- .wrapper -->
			<?php
			$target = get_theme_mod( 'wen_travel_gallery_target' ) ? '_blank': '_self';
			$wen_travel_link   = get_theme_mod( 'wen_travel_gallery_link', '#' );
			$text   = get_theme_mod( 'wen_travel_gallery_text' );
			if ( $text ) :
			?>
				<p class="view-more">
					<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
				</p>
			<?php endif; ?>
		</div><!-- .section -->
		<?php
	endwhile;
	wp_reset_postdata();
endif;
