<?php
/**
 * The template used for displaying hero content
 *
 * @package WEN_Travel
 */

$classes[] = 'hero-section';
$classes[] = 'section';
$classes[] = get_theme_mod( 'wen_travel_hero_content_img_align', 'content-align-right' );
$classes[] = get_theme_mod( 'wen_travel_hero_content_txt_align', 'text-align-left' );

$image     = get_theme_mod( 'wen_travel_hero_content_image' ); 
$video_url = get_theme_mod( 'wen_travel_hero_content_video_link' );

if ( ! $image && ! $video_url ) {
	$classes[] = 'content-full-width';
}
?>
<div id="hero-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<div class="section-content-wrapper hero-content-wrapper">
			<article id="post-0" class="hentry<?php echo $image ? ' has-post-thumbnail' : ''; ?>">
				<div class="hentry-inner">
					<?php if ( $image || $video_url ) : ?>
					<div class="thumb-video-wrapper">
						<?php if ( $image ) : ?>
							<div class="post-thumbnail-background" style="background-image: url( <?php echo esc_url( $image ); ?> )">
	                            <?php
								$wen_travel_link = get_theme_mod( 'wen_travel_hero_content_link', '#' );
								$target        = get_theme_mod( 'wen_travel_hero_content_target' ) ? '_blank' : '_self';
	                            ?>

	                            <a class="cover-link" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
	                            </a>
	                        </div><!-- .post-thumbnail -->
						<?php endif;

						if ( $video_url ) : 
							$video_title    = get_theme_mod( 'wen_travel_hero_content_video_title', esc_html__( 'Watch Our Video', 'wen-travel-pro' ) );
							$video_subtitle = get_theme_mod( 'wen_travel_hero_content_video_subtitle', esc_html__( 'The Beauty Of Ocean Tour', 'wen-travel-pro' ) );

							?>
							<div class="video-wrapper">
								<?php if ( $video_title ) : ?>
									<header class="entry-header">
										<h2 class="section-title">
											<?php echo esc_html( $video_title ); ?>
										</h2>
									</header><!-- .entry-header -->
								<?php endif; ?>

								<?php if ( $video_subtitle ) : ?>
									<div class="section-description">
										<p><?php echo esc_html( $video_subtitle ); ?></p>
									</div><!-- .section-description-wrapper -->
								<?php endif; ?>

								<a class="mixed button play-button" data-flashy-type="video" href="<?php echo esc_url( $video_url ); ?>"><?php echo wen_travel_get_svg( array( 'icon' => 'play' ) ); ?><span class="screen-reader-text"><?php esc_html_e( 'Play Video', 'wen-travel-pro' ); ?></span></a>
							</div><!-- .video-wrapper -->
						<?php endif; ?>
					</div><!-- .thumb-video-wrapper -->
					<?php endif; ?>
					
					<div class="entry-container">
						<?php
						$wen_travel_title       = get_theme_mod( 'wen_travel_hero_content_title' );
						$wen_travel_description = get_theme_mod( 'wen_travel_hero_content_description' ); 

						if ( $wen_travel_title ) : ?>
							<header class="entry-header">
								<h2 class="section-title">
									<?php echo wp_kses_post( $wen_travel_title ) ?>
								</h2>
							</header><!-- .entry-header -->
						<?php endif; ?>

						<?php if ( $wen_travel_description ) : ?>
							<div class="section-description">
								<p>
									<?php
									echo wp_kses_post( $wen_travel_description );
									?>
								</p>
							</div><!-- .section-description-wrapper -->
						<?php endif; ?>

						<?php if ( $content = get_theme_mod( 'wen_travel_hero_content_content' ) ) : ?>
						<div class="entry-content">
							<?php echo wp_kses_post( wpautop( $content ) ); ?>

							<?php
							$more_text   = get_theme_mod( 'wen_travel_hero_content_more_text' );
							$more_link   = get_theme_mod( 'wen_travel_hero_content_more_link', '#' );
							$more_target = get_theme_mod( 'wen_travel_hero_content_more_target' ) ? '_blank' : '_self' ;

							if ( $more_text ) : ?>
								<a class="more-link" href="<?php echo esc_url( $more_link ); ?>" target="<?php echo esc_attr( $more_target ); ?>">
									<span><?php echo esc_html( $more_text ); ?></span>
								</a>
							<?php
							endif;
							?>
						</div><!-- .entry-content -->
						<?php endif; ?>
					</div><!-- .entry-container -->
				</div><!-- .hentry-inner -->
			</article>
		</div><!-- .section-content-wrapper -->
	</div><!-- .wrapper -->
</div><!-- .section -->
