<?php
/**
 * The template used for displaying hero content
 *
 * @package WEN_Travel
 */
?>

<?php

$wen_travel_type = get_theme_mod( 'wen_travel_hero_content_type', 'page' );

if ( 'page' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_hero_content' ) ) {
	$args['page_id'] = absint( $wen_travel_id );
} elseif ( 'post' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_hero_content_post' ) ) {
	$args['p'] = absint( $wen_travel_id );
} elseif ( 'category' === $wen_travel_type && $wen_travel_cat = get_theme_mod( 'wen_travel_hero_content_category' ) ) {
	$args['cat'] = absint( $wen_travel_cat );
}

$args['posts_per_page']      = 1;
$args['ignore_sticky_posts'] = true;

// If $args is empty return false
if ( empty( $args ) ) {
	return;
}

// Create a new WP_Query using the argument previously created
$hero_query = new WP_Query( $args );
if ( $hero_query->have_posts() ) :
	while ( $hero_query->have_posts() ) :
		$hero_query->the_post();

		$classes[] = 'hero-section';
		$classes[] = 'section';
		$classes[] = get_theme_mod( 'wen_travel_hero_content_img_align', 'content-align-right' );
		$classes[] = get_theme_mod( 'wen_travel_hero_content_txt_align', 'text-align-left' );

		$video_url = get_theme_mod( 'wen_travel_hero_content_video_link' );

		if ( ! has_post_thumbnail() && ! $video_url ) {
			$classes[] = 'content-full-width';
		}

		if ( ! has_post_thumbnail() ) {
			$classes[] = 'no-thumb';
		}
		?>
		<div id="hero-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
			<div class="wrapper">
				<div class="section-content-wrapper hero-content-wrapper">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="hentry-inner">
							<?php if ( has_post_thumbnail() || $video_url ) : ?>
							<div class="thumb-video-wrapper">
								<?php wen_travel_post_thumbnail( 'full-image', 'html-with-bg' ); // wen_travel_post_thumbnail( $image_size, $wen_travel_type = 'html', $echo = true, $no_thumb = false ). ?>

								<?php 
								if ( $video_url ) : 
									$video_title    = get_theme_mod( 'wen_travel_hero_content_video_title', esc_html__( 'Watch Our Video', 'wen-travel-pro' ) );
									$video_subtitle = get_theme_mod( 'wen_travel_hero_content_video_subtitle', esc_html__( 'The Beauty Of Ocean Tour', 'wen-travel-pro' ) );

									?>
									<div class="video-wrapper">
										<?php if ( $video_title ) : ?>
											<header class="entry-header">
												<h2 class="section-title">
													<?php echo esc_html( $video_title ); ?>
												</h2>
											</header><!-- .entry-header -->
										<?php endif; ?>

										<?php if ( $video_subtitle ) : ?>
											<div class="section-description">
												<p><?php echo esc_html( $video_subtitle ); ?></p>
											</div><!-- .section-description-wrapper -->
										<?php endif; ?>

										<a class="mixed button play-button" data-flashy-type="video" href="<?php echo esc_url( $video_url ); ?>"><?php echo wen_travel_get_svg( array( 'icon' => 'play' ) ); ?><span class="screen-reader-text"><?php esc_html_e( 'Play Video', 'wen-travel-pro' ); ?></span></a>
									</div><!-- .video-wrapper -->
								<?php endif; ?>
							</div><!-- .thumb-video-wrapper -->
							<?php endif; ?>

							<div class="entry-container">
							<?php
							$wen_travel_title       = get_theme_mod( 'wen_travel_display_hero_content_title', 1 );
							$wen_travel_description = get_theme_mod( 'wen_travel_hero_content_description' ); 

							if ( $wen_travel_title ) : ?>
								<header class="entry-header">
									<h2 class="section-title">
										<?php the_title(); ?>
									</h2>
								</header><!-- .entry-header -->
							<?php endif; ?>

							<?php if ( $wen_travel_description ) : ?>
								<div class="section-description">
									<p>
										<?php
										echo wp_kses_post( $wen_travel_description );
										?>
									</p>
								</div><!-- .section-description-wrapper -->
							<?php endif; ?>

							<div class="entry-content">
								<?php

									$show_content = get_theme_mod( 'wen_travel_hero_content_show', 'full-content' );

									if ( 'full-content' === $show_content ) {
										the_content();
									} elseif ( 'excerpt' === $show_content ) {
										the_excerpt();
									}

									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'wen-travel-pro' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span class="page-number">',
										'link_after'  => '</span>',
										'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'wen-travel-pro' ) . ' </span>%',
										'separator'   => '<span class="screen-reader-text">, </span>',
									) );
								?>
							</div><!-- .entry-content -->

							<?php if ( get_edit_post_link() ) : ?>
								<footer class="entry-footer">
									<div class="entry-meta">
										<?php
											edit_post_link(
												sprintf(
													/* translators: %s: Name of current post */
													esc_html__( 'Edit %s', 'wen-travel-pro' ),
													the_title( '<span class="screen-reader-text">"', '"</span>', false )
												),
												'<span class="edit-link">',
												'</span>'
											);
										?>
									</div>	<!-- .entry-meta -->
								</footer><!-- .entry-footer -->
							<?php endif; ?>
						</div><!-- .hentry-inner -->
					</article>
				</div><!-- .section-content-wrapper -->
			</div><!-- .wrapper -->
		</div><!-- .section -->
	<?php
	endwhile;

	wp_reset_postdata();
endif;
