<?php
/**
 * The template for displaying latest package on the front page
 *
 * @package WEN_Travel
 */
$wen_travel_type = get_theme_mod( 'wen_travel_latest_package_type', 'category' );
$thumbnail_style = get_theme_mod( 'wen_travel_latest_package_thumbnail_style', 'style-one' );
$number          = get_theme_mod( 'wen_travel_latest_package_number', 3 );
$post_list       = array();
$no_of_post      = 0;

$args = array(
	'post_type'           => 'post',
	'ignore_sticky_posts' => 1, // ignore sticky posts.
);

// Get valid number of posts.
if ( 'post' === $wen_travel_type || 'page' === $wen_travel_type  ) {
	$args['post_type'] = $wen_travel_type;

	for ( $i = 1; $i <= $number; $i++ ) {
		$wen_travel_post_id = '';

		if ( 'post' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_latest_package_post_' . $i );
		} elseif ( 'page' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_latest_package_page_' . $i );
		}

		if ( $wen_travel_post_id && '' !== $wen_travel_post_id ) {
			$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

			$no_of_post++;
		}
	}

	$args['post__in'] = $post_list;
	$args['orderby']  = 'post__in';
} elseif ( 'category' === $wen_travel_type ) {
	if ( $wen_travel_cat = get_theme_mod( 'wen_travel_latest_package_select_category' ) ) {
		$args['category__in'] = $wen_travel_cat;
	}

	$no_of_post = $number;
} elseif ( 'destination' === $wen_travel_type ) {
	$no_of_post = $number;

	$tax_query = array();

	if ( $destinations = get_theme_mod( 'wen_travel_latest_package_select_destination' ) ) {
		$tax_query['relation'] = 'OR';

		foreach ( $destinations as $destination ) {
			$tax_query[] = array(
				'taxonomy' => 'travel_locations',
				'field'    => 'id',
				'terms'    => $destination,
			);
		}
	}

	$args['post_type'] = 'itineraries';
	$args['tax_query'] = $tax_query;
} else { 
 	$args['post_type'] = $wen_travel_type;

	for ( $i = 1; $i <= $number; $i++ ) {
		$wen_travel_post_id = '';

		$wen_travel_post_id = get_theme_mod( "wen_travel_latest_package_{$wen_travel_type}_{$i}" );

		if ( $wen_travel_post_id && '' !== $wen_travel_post_id ) {
			// Polylang Support.
			if ( class_exists( 'Polylang' ) ) {
				$wen_travel_post_id = pll_get_post( $wen_travel_post_id, pll_current_language() );
			}

			$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

			$no_of_post++;
		}
	}

	$args['post__in'] = $post_list;
	$args['orderby']  = 'post__in';
} 

if ( ! $no_of_post ) {
	return;
}

$args['posts_per_page'] = $no_of_post;

$loop = new WP_Query( $args );

$show_content = get_theme_mod( 'wen_travel_latest_package_show', 'excerpt' );

while ( $loop->have_posts() ) :
	
	$loop->the_post();

	$price_text   = get_theme_mod( 'wen_travel_latest_package_price_text' . ( absint( $loop->current_post ) + 1 ) );
	$price_amount = get_theme_mod( 'wen_travel_latest_package_price_amount' . ( absint( $loop->current_post ) + 1 ) );
	$text   	  = get_theme_mod( 'wen_travel_latest_package_button_text_' . ( absint( $loop->current_post ) + 1 ) );
	$link         = get_theme_mod( 'wen_travel_latest_package_button_link_' . ( absint( $loop->current_post ) + 1 ) );

	$class = '';
	if( $price_amount || $price_text || $text ) {
		$class = 'has-price';
	} else {
		$class = 'no-price';
	}

	if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) { 
		$wp_travel_metas = wen_travel_wp_travel_get_itinerary_meta();

		// Prices and currency.
		$currency_code = ! empty( $wp_travel_metas['prices']['currency_code'] ) ? $wp_travel_metas['prices']['currency_code'] : false;
		$trip_price    = ! empty( $wp_travel_metas['prices']['trip_price'] ) ? $wp_travel_metas['prices']['trip_price'] : false; // This will give sales price if sale is enabled.

		$pax          = ! empty( $wp_travel_metas['general']['pax'] ) ? $wp_travel_metas['general']['pax'] : '';
		$ratings_html = ! empty( $wp_travel_metas['general']['ratings_html'] ) ? $wp_travel_metas['general']['ratings_html'] : '';
		$activities    = ! empty( $wp_travel_metas['trip_terms']['activity'] ) ? $wp_travel_metas['trip_terms']['activity'] : '';
		$activity      = ! empty( $activities[0] ) ? $activities[0] : '';
		$activity_id   = ! empty( $activity->term_id ) ? $activity->term_id : '';
		$activity_name = ! empty( $activity->name ) ? $activity->name : '';
		$activity_link = ! empty( $activity_id ) ? get_term_link( $activity_id ) : '';
	}

	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="hentry-inner <?php echo esc_attr( $class ); ?>">
			<?php

			wen_travel_post_thumbnail( array(926, 1158), 'html', true, false ); ?>
		
			<div class="entry-container">	
				<header class="entry-header">
					<?php if ( 'psot' === $wen_travel_type || 'category' === $wen_travel_type ) : ?>
					<div class="entry-meta">
						<?php wen_travel_by_line(); ?>

						<?php wen_travel_cat_list(); ?>
					</div><!-- .entry-meta -->
					<?php endif; 

					if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) { ?>
						<div class="entry-meta">
							<ul class="list-inline">
						<?php if ( $activity_name ) {
							?>
							<li class="list-inline-item">
								<a href="<?php echo esc_url( $activity_link ); ?>" class=""><?php echo wen_travel_get_svg( array( 'icon' => 'paper-plane' ) ); echo esc_html( $activity_name ); ?></a>
							</li>
							<?php
						}

						if ( $pax ) {
							?>
							<li class="list-inline-item">
								<?php echo wen_travel_get_svg( array( 'icon' => 'user' ) ); echo esc_html( $pax ); ?>
							</li>
							<?php
						}
						the_date(
							'',
							'<li class="list-inline-item">' . wen_travel_get_svg( array( 'icon' => 'clock' ) ) .' ',
							'</li>'
						); ?>
							</ul>
						</div>
					<?php }  

					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">','</a></h2>' ); 
					
					if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) {
						echo wp_kses_post( $ratings_html );
					} ?>
				</header>	
				<?php wen_travel_content_display( $show_content ); ?>
			
			</div><!-- .entry-container -->

			<?php if( 'destination' === $wen_travel_type || 'itineraries' === $wen_travel_type ) :  ?>
			<div class="button-wrap">
				<?php 

				if ( ! empty( $trip_price ) ) { 
					?>
					<div class="price">
						<span class="label">price</span>
						<?php
						echo $trip_price ? sprintf( '<span class="amount">%s%d</span>', esc_html( $currency_code ), esc_html( $trip_price ) ) : '';
						?>
					</div>
					<?php
				}
				?>

			<?php else : ?>	
				<?php if( $price_amount || $price_text ) : ?>
					<div class="price">
						<span class="label"><?php echo esc_html( $price_text ); ?></span>
						<span class="amount"><?php echo esc_html( $price_amount ); ?></span>
					</div>	
				<?php endif; 
			endif; 
	
				if( 'destination' === $wen_travel_type || 'itineraries' === $wen_travel_type ) : ?>
					<div class="more-button ghost-button">
						<a href="<?php the_permalink(); ?>" class="more-link">
							<?php esc_html_e( 'Explore', 'wen-travel-pro' ); ?>
						</a>
			        </div>						
		    	<?php else : 
		    		if( $text ) : ?>
	    				<div class="more-button ghost-button">
	    					<a class="more-link" href="<?php echo esc_url( $link ); ?>">
	    						<?php echo esc_html( $text ); ?>
	    					</a>
	    		        </div>
			    	<?php endif; 	
			endif; ?> 
		</div><!-- .hentry-inner -->
	</article>
<?php
endwhile;

wp_reset_postdata();
