<?php
/**
 * The template for displaying latest package custom content
 *
 * @package WEN_Travel
 */

$thumbnail_style = get_theme_mod( 'wen_travel_latest_package_thumbnail_style', 'style-one' );
$quantity 	     = get_theme_mod( 'wen_travel_latest_package_number', 3 );

for ( $i = 1; $i <= $quantity; $i++ ) {
	$target = get_theme_mod( 'wen_travel_latest_package_target_' . $i ) ? '_blank' : '_self';
	$price_text   = get_theme_mod( 'wen_travel_latest_package_price_text' . $i );
	$price_amount = get_theme_mod( 'wen_travel_latest_package_price_amount' . $i );
	$text   	  = get_theme_mod( 'wen_travel_latest_package_button_text_' . $i );
	$link   	  = get_theme_mod( 'wen_travel_latest_package_button_link_' . $i );

	$wen_travel_link = get_theme_mod( 'wen_travel_latest_package_link_' . $i ) ? get_theme_mod( 'wen_travel_latest_package_link_' . $i ) : '#';

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	$class = '';
	if( $price_amount || $price_text || $text ) {
		$class = 'has-price';
	} else {
		$class = 'no-price';
	}

	echo '
	<article id="latest-package-post-' . esc_attr( $i ) . '" class="hentry latest-package-image-content">
		<div class="hentry-inner ' . esc_attr( $class ) . '">';

			$wen_travel_title   = get_theme_mod( 'wen_travel_latest_package_title_' . $i );
			$content = get_theme_mod( 'wen_travel_latest_package_content_' . $i );

			$image = get_theme_mod( 'wen_travel_latest_package_image_' . $i ) ? get_theme_mod( 'wen_travel_latest_package_image_' . $i ) : '';

			if( $image ) {
				echo '<div class="post-thumbnail">
					<a class="cover-link" href="' . esc_url( $wen_travel_link ) . '">
						<img src="' . esc_url( $image ) . '">
					</a>
				</div>'; 
			} 
			
			if ( $wen_travel_title || $content ) {
				echo '
				<div class="entry-container">';

				if ( $wen_travel_title ) {
					echo '
					<header class="latest-package entry-header">
						<h2 class="entry-title">
							<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . wp_kses_post( $wen_travel_title ) . '</a>
						</h2>
					</header>';
				}

				if ( '' !== $content ) {
					echo '
					<div class="entry-summary">' . wp_kses_post( apply_filters( 'the_content', $content ) ) . '
					</div><!-- .entry-summary -->';
				}

				echo '
				</div><!-- .entry-container -->';

				if( $price_amount || $text || $price_text ) :  
					echo '<div class="button-wrap">';

						if( $price_amount || $price_text ) : 
							echo '<div class="price">
									<span class="label">' . esc_html( $price_text ). '</span>
									<span class="amount">' . esc_html( $price_amount ). '</span>								
							</div>';
						endif;

						if( $text ) : 
							echo '<div class="more-button ghost-button">
					            	<a class="more-link" href="' . esc_url( $link ) . '?>">' . esc_html( $text ). '</a>
					        </div>';
				        endif;

					echo '</div>';
				endif;
			}

		echo '
		</div><!-- .hentry-inner -->
	</article><!-- .featured-post-' . esc_attr( $i ) . ' -->';
} // End for().
