<?php
/**
 * The template for displaying latest package
 *
 * @package WEN_Travel
 */

$enable_content  = get_theme_mod( 'wen_travel_latest_package_option', 'disabled' );
$wen_travel_type = get_theme_mod( 'wen_travel_latest_package_type', 'category' );

if ( ! wen_travel_check_section( $enable_content ) ) {
	// Bail if featured content is disabled.
	return;
}

if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) {
	if ( ! class_exists( 'WP_Travel' ) ) {
		// Bail if there Wp travel plugin is not activated for itineries and destination.
		return;
	}
}

$wen_travel_title       = get_theme_mod( 'wen_travel_latest_package_title' );
$wen_travel_description = get_theme_mod( 'wen_travel_latest_package_description' );

$classes[] = $wen_travel_type;
$classes[] = 'section';
$classes[] = 'ghost-button';

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}
?>

<div id="latest-package-section" class="latest-package-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">

				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper latest-package-wrapper">
			<?php
				if ( 'custom' === $wen_travel_type ) {
					get_template_part( 'template-parts/latest-package/custom-latest-package' );
				} else {
					get_template_part( 'template-parts/latest-package/content-latest-package' );
				}
			?>
		</div><!-- .section-content-wrap -->
	</div><!-- .wrapper -->
</div><!-- #latest-package-section -->
