<?php
/**
 * Displays Footer Navigation
 *
 * @package WEN_Travel
 */
?>

<?php if ( has_nav_menu( 'social-footer' ) ) : ?>
	<div id="footer-menu-section" class="site-footer-menu">
		<div class="wrapper">
			<nav id="social-footer-navigation" class="social-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Footer Social Links Menu', 'wen-travel-pro' ); ?>">
				<?php
					wp_nav_menu( array(
						'theme_location' => 'social-footer',
						'menu_class'     => 'social-links-menu',
						'depth'          => 1,
						'link_before'    => '<span class="screen-reader-text">',
						'link_after'       => '</span>' . wen_travel_get_svg( array( 'icon' => 'chain' ) ),

					) );
				?>
			</nav><!-- .social-navigation -->
		</div><!-- .wrapper -->
	</div><!-- #footer-menu-section -->
<?php endif;
