<?php
/**
 * The template for displaying portfolio items
 *
 * @package WEN_Travel
 */

$enable = get_theme_mod( 'wen_travel_portfolio_two_option', 'disabled' );

if ( ! wen_travel_check_section( $enable ) ) {
	// Bail if portfolio section is disabled.
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_portfolio_two_type', 'category' );

if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) {
	if ( ! class_exists( 'WP_Travel' ) ) {
		// Bail if there Wp travel plugin is not activated for itineries and destination.
		return;
	}
}

$wen_travel_title       = get_theme_mod( 'wen_travel_portfolio_two_title');
$wen_travel_description = get_theme_mod( 'wen_travel_portfolio_two_description' );

if ( 'jetpack-portfolio' === $wen_travel_type ) {
	$wen_travel_title       = get_option( 'jetpack_portfolio_title', esc_html__( 'Projects', 'wen-travel-pro' ) );
	$wen_travel_description = get_option( 'jetpack_portfolio_content' );
}

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}

$layout = get_theme_mod( 'wen_travel_portfolio_two_layout', 'layout-three' );

$classes[] = $layout;
$classes[] = $wen_travel_type;
$classes[] = 'section';

if ( get_theme_mod( 'wen_travel_portfolio_two_bg_image' ) ) {
	$classes[] = 'has-background-image';
}
?>

<div id="portfolio-two-content-section" class="portfolio-content-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">
				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper portfolio-content-wrapper <?php echo esc_attr( $layout ); ?>">

			<?php if ( 'category' === $wen_travel_type && ! empty( $cats = get_theme_mod( 'wen_travel_portfolio_two_select_category' ) ) ) : ?>
			<div class="filter-button-group button-group">
				<button class="button is-checked" data-filter="*"><?php esc_html_e( 'Show All', 'wen-travel-pro' ) ?></button>
				<?php
				foreach ( $cats as $wen_travel_cat ) {
					$catinfo = get_category( $wen_travel_cat );
					?>
					<button class="button" data-filter=".category-<?php echo esc_attr( $catinfo->slug ); ?>"><?php echo esc_html( $catinfo->name ); ?></button>
					<?php
				}
			    ?>
			</div>
			<?php endif;?>

			<?php if ( 'destination' === $wen_travel_type && ! empty( $destinations = get_theme_mod( 'wen_travel_portfolio_two_select_destination' ) ) ) : ?>
			<div class="filter-button-group button-group">
				<button class="button is-checked" data-filter="*"><?php esc_html_e( 'Show All', 'wen-travel-pro' ) ?></button>
				<?php
				foreach ( $destinations as $destination ) {
					if ( ! is_wp_error( $destination ) ) {
						$destination_info = get_term( $destination );
						?>
						<button class="button" data-filter=".<?php echo esc_attr( 'travel_locations-' . $destination_info->slug ); ?>"><?php echo esc_html( $destination_info->name ); ?></button>
						<?php
					}
				}
			    ?>
			</div>
			<?php endif;?>

			<?php if ( 'jetpack-portfolio-type' === $wen_travel_type && ! empty( $project_types = get_theme_mod( 'wen_travel_portfolio_two_select_project_type' ) ) ) : ?>
			<div class="filter-button-group button-group js-radio-button-group">
				<button class="button is-checked" data-filter="*"><?php esc_html_e( 'All', 'wen-travel-pro' ) ?></button>
				<?php
				foreach ( $project_types as $project_type ) {
					if ( ! is_wp_error( $project_type ) ) {
						$project_type_info = get_term( $project_type );
						?>
						<button class="button" data-filter=".<?php echo esc_attr( 'jetpack-portfolio-type-' . $project_type_info->slug ); ?>"><?php echo esc_html( $project_type_info->name ); ?></button>
						<?php
					}
				}
			    ?>
			</div>
			<?php endif;?>

			<div class="grid">
				<?php
				if ( 'custom' === $wen_travel_type ) {
					get_template_part( 'template-parts/portfolio-two/image', 'portfolio' );
				} else {
					get_template_part( 'template-parts/portfolio-two/post-types', 'portfolio' );
				}
				?>
			</div><!-- .grid -->
		</div><!-- .section-content-wrap -->

		<?php
			$target          = get_theme_mod( 'wen_travel_portfolio_two_target' ) ? '_blank': '_self';
			$wen_travel_link = get_theme_mod( 'wen_travel_portfolio_two_link', '#' );
			$text            = get_theme_mod( 'wen_travel_portfolio_two_text' );

			if ( $text ) :
		?>

		<p class="view-more">
			<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
		</p>
		<?php endif; ?>
	</div><!-- .wrapper -->
</div><!-- #portfolio-section -->
