<?php
/**
 * The template for displaying portfolio items
 *
 * @package WEN_Travel
 */
?>

<?php
$number = get_theme_mod( 'wen_travel_portfolio_two_number', 6 );

if ( ! $number ) {
	// If number is 0, then this section is disabled
	return;
}

$slider_select = get_theme_mod( 'wen_travel_portfolio_two_slider', 1 );

for ( $i = 1; $i <= $number; $i++ ) {
	$target = get_theme_mod( 'wen_travel_portfolio_two_target_' . $i ) ? '_blank': '_self';
	$wen_travel_title  = get_theme_mod( 'wen_travel_portfolio_two_title_' . $i );
	$image  = get_theme_mod( 'wen_travel_portfolio_two_image_' . $i ) ? get_theme_mod( 'wen_travel_portfolio_two_image_' . $i ) :  trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-508x508.jpg';
	$wen_travel_link   = get_theme_mod( 'wen_travel_portfolio_two_link_' . $i, '#' );

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	?>
	<article id="portfolio-post-<?php echo esc_attr( $i ) ?>" class="hentry post-image">
		<div class="hentry-inner">
			<div class="portfolio-thumbnail post-thumbnail">
				<?php if ( $wen_travel_link ) : ?>
				<a class="post-thumbnail" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo $target; ?>">
				<?php endif; ?>
					<img src="<?php echo esc_url( $image ); ?>" class="wp-post-image" alt="<?php echo esc_attr( $wen_travel_title ); ?>" title="<?php echo esc_attr( $wen_travel_title ); ?>">
				<?php if ( $wen_travel_link ) : ?>
				</a>
				<?php endif; ?>
			</div>

			<div class="entry-container caption">
				<div class="entry-container-inner-wrap">
					<?php
					if ( $wen_travel_title ) : ?>
					<header class="entry-header">
						<h2 class="entry-title">
							<?php if ( $wen_travel_link ) : ?>
							<a class="post-thumbnail" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo $target; ?>">
							<?php endif; ?>
								<?php echo wp_kses_post( $wen_travel_title ); ?>
							<?php if ( $wen_travel_link ) : ?>
							</a>
							<?php endif; ?>
						</h2>
					</header>
					<?php endif; ?>
				</div><!-- .entry-container-inner-wrap -->	
			</div><!-- .entry-container -->
		</div><!-- .hentry-inner -->
	</article>
<?php
}
