<?php
/**
 * The template for displaying portfolio items
 *
 * @package WEN_Travel
 */

$number = get_theme_mod( 'wen_travel_portfolio_two_number', 6 );

if ( ! $number ) {
	// If number is 0, then this section is disabled
	return;
}

$wen_travel_args = array(
	'orderby'             => 'post__in',
	'ignore_sticky_posts' => 1 // ignore sticky posts
);

$post_list  = array();// list of valid post/page ids

$no_of_post = 0; // for number of posts

$wen_travel_type = get_theme_mod( 'wen_travel_portfolio_two_type', 'category' );

if ( 'category' === $wen_travel_type ) {
	$no_of_post = $number;

	if ( get_theme_mod( 'wen_travel_portfolio_two_select_category' ) ) {
		$wen_travel_args['category__in'] = get_theme_mod( 'wen_travel_portfolio_two_select_category' );
	}

	$wen_travel_args['post_type'] = 'post';
	$wen_travel_args['orderby'] = 'id';
} elseif ( 'jetpack-portfolio-type' === $wen_travel_type ) {
	$no_of_post = $number;

	$tax_query = array();

	if ( $project_types = get_theme_mod( 'wen_travel_portfolio_select_project_type' ) ) {
		$tax_query['relation'] = 'OR';

		foreach ( $project_types as $project_type ) {
			$tax_query[] = array(
				'taxonomy' => 'jetpack-portfolio-type',
				'field'    => 'id',
				'terms'    => $project_type,
			);
		}
	}

	$wen_travel_args['post_type'] = 'jetpack-portfolio';
	$wen_travel_args['tax_query'] = $tax_query;
} elseif ( 'destination' === $wen_travel_type ) {
	$no_of_post = $number;

	$tax_query = array();

	if ( $destinations = get_theme_mod( 'wen_travel_portfolio_select_destination' ) ) {
		$tax_query['relation'] = 'OR';

		foreach ( $destinations as $destination ) {
			$tax_query[] = array(
				'taxonomy' => 'travel_locations',
				'field'    => 'id',
				'terms'    => $destination,
			);
		}
	}

	$wen_travel_args['post_type'] = 'itineraries';
	$wen_travel_args['tax_query'] = $tax_query;
} else {
	if ( 'cpt' === $wen_travel_type ) {
		$wen_travel_args['post_type'] = 'jetpack-portfolio';
	} else {
		$wen_travel_args['post_type'] = $wen_travel_type;
	}

	for ( $i = 1; $i <= $number; $i++ ) {
		$wen_travel_post_id = '';

		$wen_travel_post_id = get_theme_mod( "wen_travel_portfolio_two_{$wen_travel_type}_{$i}" );

		if ( $wen_travel_post_id && '' !== $wen_travel_post_id ) {
			// Polylang Support.
			if ( class_exists( 'Polylang' ) ) {
				$wen_travel_post_id = pll_get_post( $wen_travel_post_id, pll_current_language() );
			}

			$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

			$no_of_post++;
		}
	}

	$wen_travel_args['post__in'] = $post_list;
} 

if ( 0 === $no_of_post ) {
	return;
}

$wen_travel_args['posts_per_page'] = $no_of_post;
$loop     = new WP_Query( $wen_travel_args );

$slider_select = get_theme_mod( 'wen_travel_portfolio_two_slider', 1 );

if ( $loop -> have_posts() ) :
	while ( $loop -> have_posts() ) :
		$loop -> the_post();

		get_template_part( 'template-parts/portfolio-two/content', 'portfolio' );

	endwhile;
	wp_reset_postdata();
endif;
