<?php
/**
 * The template used for displaying projects on index view
 *
 * @package WEN_Travel
 */

$show_meta = get_theme_mod( 'wen_travel_portfolio_meta_show', 'show-meta' );
$layout    = get_theme_mod( 'wen_travel_portfolio_content_layout', 'layout-three' );

global $post;

$classes = 'grid-item';

$wen_travel_type = get_theme_mod( 'wen_travel_portfolio_type', 'category' );

if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) {
	$wp_travel_metas = wen_travel_wp_travel_get_itinerary_meta();

	// Prices and currency.
	$currency_code = ! empty( $wp_travel_metas['prices']['currency_code'] ) ? $wp_travel_metas['prices']['currency_code'] : false;
	$trip_price    = ! empty( $wp_travel_metas['prices']['trip_price'] ) ? $wp_travel_metas['prices']['trip_price'] : false; // This will give sales price if sale is enabled.

	$pax          = ! empty( $wp_travel_metas['general']['pax'] ) ? $wp_travel_metas['general']['pax'] : '';
	$ratings_html = ! empty( $wp_travel_metas['general']['ratings_html'] ) ? $wp_travel_metas['general']['ratings_html'] : '';
}
?>

<article id="portfolio-post-<?php the_ID(); ?>" <?php post_class( esc_attr( $classes ) ); ?>>
	<div class="hentry-inner">
		<?php wen_travel_post_thumbnail( 'wen-travel-archive', 'html', true, true ); ?>
		
		<div class="entry-container caption">
			<div class="entry-container-inner-wrap">
				<header class="entry-header">
				<div class="entry-price">	
					<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

						<?php 
						if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) {
							echo wp_kses_post( $ratings_html );
						}
					?>
				</div>
					<?php
					if ( ! empty( $trip_price ) ) {
						?>
						<div class="price">
							<span class="label">price</span>
							<?php
							echo $trip_price ? sprintf( '<span class="amount">%s%d</span>', esc_html( $currency_code ), esc_html( $trip_price ) ) : '';
							?>
						</div>
						<?php
					}
					?>
				</header>

				<div class="trip-footer">
					<?php if ( 'show-meta' === $show_meta ) : ?>
					<div class="entry-meta">
						<?php
						if ( ! ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) ) :
							wen_travel_posted_on();
						else : ?>
							<?php if ( ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) && $pax ) : ?>
							<?php echo wen_travel_get_svg( array( 'icon' => 'user' ) ); echo esc_html( $pax ); ?>
							<?php endif;
						endif;
						?>
					</div><!-- .entry-meta -->
					<?php endif; ?>

					<?php if ( 'itineraries' === $wen_travel_type || 'destination' === $wen_travel_type ) : ?>
					<div class="more-button ghost-button">
						<a href="<?php the_permalink(); ?>" class="more-link">
							<?php esc_html_e( 'Details', 'wen-travel-pro' ); ?>
						</a>
					</div><!-- .more-button -->
					<?php endif; ?>
				</div><!-- .trip-footer -->
			</div><!-- .entry-container-inner-wrap -->	
		</div><!-- .entry-container -->
	</div><!-- .hentry-inner -->
</article>
