<?php
/**
 * The template used for displaying promotion headline
 *
 * @package WEN_Travel
 */

$classes[] = 'section';
$classes[] = 'promotion-section';
$classes[] = get_theme_mod( 'wen_travel_promo_head_image_position', 'content-align-center' );
$classes[] = get_theme_mod( 'wen_travel_promo_head_text_alignment', 'text-align-center' );

$wen_travel_description = get_theme_mod( 'wen_travel_promo_head_description' );

if ( get_theme_mod( 'wen_travel_promo_head_wrap_text' ) ) {
	$classes[] = 'content-frame';
}

if ( get_theme_mod( 'wen_travel_promo_head_text_color', 1 ) ) {
   $classes[] = 'content-color-white';
}

$image     = get_theme_mod( 'wen_travel_promo_head_image' ); 
$video_url = get_theme_mod( 'wen_travel_promo_head_video_link' );

if ( ! $image && ! $video_url ) {
	$classes[] = 'content-full-width';
}
?>
<div id="promotion-section" class="promotion-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper section-content-wrapper">
		<article class="promotion-headline-image type-image hentry">
			<div class="hentry-inner">
				<?php if ( $image ) : ?>
					<div class="thumb-wrapper">
						<div class="post-thumbnail-background" style="background-image: url( <?php echo esc_url( $image ); ?> )">
                            <?php
							$wen_travel_link = get_theme_mod( 'wen_travel_promo_head_link', '#' );
							$target          = get_theme_mod( 'wen_travel_promo_head_target' ) ? '_blank' : '_self';
                            ?>

                            <a class="cover-link" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
                            </a>
                        </div><!-- .post-thumbnail -->
					</div><!-- .thumb-wrapper -->
				<?php endif; ?>

				<div class="content-wrapper">
					<div class="entry-container">
						<div class="entry-container-frame">
							<?php if ( $wen_travel_title = get_theme_mod( 'wen_travel_promo_head_title' ) ) : ?>
								<header class="entry-header section-title-wrapper">
									<h2 class="entry-title section-title ">
										<?php echo wp_kses_post( $wen_travel_title ); ?>
									</h2>
								</header><!-- .entry-header -->
							<?php endif; ?>

							<?php if ( $wen_travel_description ) : ?>
								<div class="section-description">
									<p>
										<?php
											echo wp_kses_post( $wen_travel_description );
										?>
									</p>
								</div><!-- .section-description-wrapper -->
							<?php endif;
							
							if ( $video_url ) : 
										?>
								<div class="video-wrapper">
									<a class="mixed button play-button" data-flashy-type="video" href="<?php echo esc_url( $video_url ); ?>"><?php echo wen_travel_get_svg( array( 'icon' => 'play' ) ); ?><span class="screen-reader-text"><?php esc_html_e( 'Play Video', 'wen-travel-pro' ); ?></span></a>
								</div><!-- .video-wrapper -->
							<?php endif;

							$content 	 = get_theme_mod( 'wen_travel_promo_head_content' );
							$more_text   = get_theme_mod( 'wen_travel_promo_head_more_text' );
							$more_link   = get_theme_mod( 'wen_travel_promo_head_more_link', '#' );
							$more_target = get_theme_mod( 'wen_travel_promo_head_more_target' ) ? '_blank' : '_self' ;

							if ( $content || $more_text ) : ?>
								<div class="entry-content">
									<?php echo wp_kses_post( wpautop( $content ) ); 
									
									if ( $more_text ) : ?>
										<a class="more-link" href="<?php echo esc_url( $more_link ); ?>" target="<?php echo esc_attr( $more_target ); ?>"><span><?php echo esc_html( $more_text ); ?></span></a>
									<?php
									endif;
									?>
								</div><!-- .entry-content -->
							<?php endif; ?>
						</div><!-- .entry-container-frame -->
					</div><!-- .entry-container -->
				</div><!-- .content-wrapper -->
			</div><!-- .hentry-inner -->
		</article><!-- #post-## -->
	</div><!-- .section-content-wrap -->
</div><!-- .section -->
