<?php
/**
 * The template used for displaying promotion headline
 *
 * @package WEN_Travel
 */

$wen_travel_type        = get_theme_mod( 'wen_travel_promo_head_type', 'page' );
$wen_travel_subtitle    = get_theme_mod( 'wen_travel_promo_head_sub_title' );
$wen_travel_description = get_theme_mod( 'wen_travel_promo_head_description' );

if ( 'page' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_promo_head' ) ) {
	$args['page_id'] = absint( $wen_travel_id );
} elseif ( 'post' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_promo_head_post' ) ) {
	$args['p'] = absint( $wen_travel_id );
} elseif ( 'product' === $wen_travel_type && $wen_travel_id = get_theme_mod( 'wen_travel_promo_head_product' ) ) {
	$args['post_type'] = 'product';
	$args['p'] = absint( $wen_travel_id );
} elseif ( 'category' === $wen_travel_type && $wen_travel_cat = get_theme_mod( 'wen_travel_promo_head_category' ) ) {
	$args['cat']            = absint( $wen_travel_cat );
}

$args['posts_per_page']      = 1;
$args['ignore_sticky_posts'] = true;

// If $args is empty return false
if ( empty( $args ) ) {
	return;
}

$video_url = get_theme_mod( 'wen_travel_promo_head_video_link' );

// Create a new WP_Query using the argument previously created
$wen_travel_query = new WP_Query( $args );
if ( $wen_travel_query->have_posts() ) :
	while ( $wen_travel_query->have_posts() ) :
		$wen_travel_query->the_post();

		$classes[] = 'section';
		$classes[] = 'promotion-section';
		$classes[] = get_theme_mod( 'wen_travel_promo_head_image_position', 'content-align-center' );
		$classes[] = get_theme_mod( 'wen_travel_promo_head_text_alignment', 'text-align-center' );

		if ( ! has_post_thumbnail() ) {
			$classes[] = 'no-thumb';
		}

		if ( ! has_post_thumbnail() && ! $video_url ) {
			$classes[] = 'content-full-width';
		}

		if ( get_theme_mod( 'wen_travel_promo_head_wrap_text' ) ) {
			$classes[] = 'content-frame';
		}

		if ( get_theme_mod( 'wen_travel_promo_head_text_color', 1 ) ) {
			$classes[] = 'content-color-white';
		}
		?>
		<div id="promotion-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
			<div class="wrapper section-content-wrapper">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="hentry-inner">
						<?php if ( has_post_thumbnail() ) : ?>
						<div class="thumb-wrapper">
							<?php wen_travel_post_thumbnail( 'wen-travel-slider', 'html-with-bg' ); // wen_travel_post_thumbnail( $image_size, $wen_travel_type = 'html', $echo = true, $no_thumb = false ). ?>
						</div><!-- .thumb-wrapper -->
						<?php endif; ?>

						<div class="content-wrapper">
							<div class="entry-container">
								<div class="entry-container-frame">
									<?php if( $wen_travel_subtitle ) : ?>
										<div class="section-subtitle">
											<?php echo esc_html( $wen_travel_subtitle ); ?>
										</div>
									<?php endif; ?>

									<?php if ( get_theme_mod( 'wen_travel_display_promo_head_title' ) ) : ?>
										<header class="entry-header section-title-wrapper">
											<?php the_title( '<h2 class="entry-title section-title">', '</h2>' ); ?>
										</header><!-- .entry-header -->
									<?php endif; ?>

									<?php if ( $wen_travel_description ) : ?>
										<div class="section-description">
											<p>
												<?php
													echo wp_kses_post( $wen_travel_description );
												?>
											</p>
										</div><!-- .section-description-wrapper -->
									<?php endif;

									if ( $video_url ) : 
										?>
										<div class="video-wrapper">
											<a class="mixed button play-button" data-flashy-type="video" href="<?php echo esc_url( $video_url ); ?>"><?php echo wen_travel_get_svg( array( 'icon' => 'play' ) ); ?><span class="screen-reader-text"><?php esc_html_e( 'Play Video', 'wen-travel-pro' ); ?></span></a>
										</div><!-- .video-wrapper -->
									<?php endif;
									
									$show_content = get_theme_mod( 'wen_travel_promo_head_show', 'full-content' );

									if ( 'full-content' === $show_content ) { ?>
										<div class="entry-content">
											<?php
											the_content();

											wp_link_pages( array(
												'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'wen-travel-pro' ) . '</span>',
												'after'       => '</div>',
												'link_before' => '<span class="page-number">',
												'link_after'  => '</span>',
												'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'wen-travel-pro' ) . ' </span>%',
												'separator'   => '<span class="screen-reader-text">, </span>',
											) );
											?>
										</div><!-- .entry-content -->
									<?php
									}
									elseif ( 'excerpt' === $show_content ) { ?>
										<div class="entry-summary">
											<?php the_excerpt(); ?>
										</div><!-- .entry-summary -->
									<?php
									} ?>
								</div><!-- .entry-container-frame -->
							</div><!-- .entry-container -->
						</div><!-- .content-wrapper -->
					</div><!-- .hentry-inner -->
				</article><!-- #post-## -->
			</div><!-- .wrapper -->
		</div><!-- .section -->
	<?php
	endwhile;
	wp_reset_postdata();
endif;
